/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.ErasureDecodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class XORErasureDecoder
extends AbstractErasureDecoder {
    public XORErasureDecoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public XORErasureDecoder(ECSchema schema) {
        super(schema);
    }

    @Override
    protected ErasureCodingStep prepareDecodingStep(ECBlockGroup blockGroup) {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
        RawErasureDecoder rawDecoder = CodecUtil.createRawDecoder(this.getConf(), "xor", coderOptions);
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new ErasureDecodingStep(inputBlocks, this.getErasedIndexes(inputBlocks), this.getOutputBlocks(blockGroup), rawDecoder);
    }

    @Override
    protected ECBlock[] getOutputBlocks(ECBlockGroup blockGroup) {
        int i;
        int erasedNum = this.getNumErasedBlocks(blockGroup);
        ECBlock[] outputBlocks = new ECBlock[erasedNum];
        int idx = 0;
        for (i = 0; i < this.getNumParityUnits(); ++i) {
            if (!blockGroup.getParityBlocks()[i].isErased()) continue;
            outputBlocks[idx++] = blockGroup.getParityBlocks()[i];
        }
        for (i = 0; i < this.getNumDataUnits(); ++i) {
            if (!blockGroup.getDataBlocks()[i].isErased()) continue;
            outputBlocks[idx++] = blockGroup.getDataBlocks()[i];
        }
        return outputBlocks;
    }
}

