/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureEncoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.ErasureEncodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class XORErasureEncoder
extends AbstractErasureEncoder {
    public XORErasureEncoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public XORErasureEncoder(ECSchema schema) {
        super(schema);
    }

    @Override
    protected ErasureCodingStep prepareEncodingStep(ECBlockGroup blockGroup) {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
        RawErasureEncoder rawEncoder = CodecUtil.createRawEncoder(this.getConf(), "xor", coderOptions);
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new ErasureEncodingStep(inputBlocks, this.getOutputBlocks(blockGroup), rawEncoder);
    }
}

