/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.protobuf.ByteString;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Credentials
implements Writable {
    private static final Log LOG = LogFactory.getLog(Credentials.class);
    private Map<Text, byte[]> secretKeysMap = new HashMap<Text, byte[]>();
    private Map<Text, Token<? extends TokenIdentifier>> tokenMap = new HashMap<Text, Token<? extends TokenIdentifier>>();
    private static final byte[] TOKEN_STORAGE_MAGIC = "HDTS".getBytes(StandardCharsets.UTF_8);
    private static final byte TOKEN_STORAGE_VERSION = 1;
    private static final byte OLD_TOKEN_STORAGE_VERSION = 0;

    public Credentials() {
    }

    public Credentials(Credentials credentials) {
        this.addAll(credentials);
    }

    public Token<? extends TokenIdentifier> getToken(Text alias) {
        return this.tokenMap.get(alias);
    }

    public void addToken(Text alias, Token<? extends TokenIdentifier> t) {
        if (t == null) {
            LOG.warn((Object)("Null token ignored for " + alias));
        } else if (this.tokenMap.put(alias, t) != null) {
            HashMap<Text, Token.PrivateToken<? extends TokenIdentifier>> tokensToAdd = new HashMap<Text, Token.PrivateToken<? extends TokenIdentifier>>();
            for (Map.Entry<Text, Token<? extends TokenIdentifier>> e : this.tokenMap.entrySet()) {
                Token<? extends TokenIdentifier> token = e.getValue();
                if (!(token instanceof Token.PrivateToken) || !((Token.PrivateToken)token).getPublicService().equals(alias)) continue;
                Token.PrivateToken<? extends TokenIdentifier> privateToken = new Token.PrivateToken<TokenIdentifier>(t);
                privateToken.setService(token.getService());
                tokensToAdd.put(e.getKey(), privateToken);
            }
            this.tokenMap.putAll(tokensToAdd);
        }
    }

    public Collection<Token<? extends TokenIdentifier>> getAllTokens() {
        return this.tokenMap.values();
    }

    public int numberOfTokens() {
        return this.tokenMap.size();
    }

    public byte[] getSecretKey(Text alias) {
        return this.secretKeysMap.get(alias);
    }

    public int numberOfSecretKeys() {
        return this.secretKeysMap.size();
    }

    public void addSecretKey(Text alias, byte[] key) {
        this.secretKeysMap.put(alias, key);
    }

    public void removeSecretKey(Text alias) {
        this.secretKeysMap.remove(alias);
    }

    public List<Text> getAllSecretKeys() {
        ArrayList<Text> list = new ArrayList<Text>();
        list.addAll(this.secretKeysMap.keySet());
        return list;
    }

    public static Credentials readTokenStorageFile(Path filename, Configuration conf) throws IOException {
        Credentials credentials;
        FSDataInputStream in = null;
        Credentials credentials2 = new Credentials();
        try {
            in = filename.getFileSystem(conf).open(filename);
            credentials2.readTokenStorageStream(in);
            in.close();
            credentials = credentials2;
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Exception reading " + filename, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, in);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, in);
        return credentials;
    }

    public static Credentials readTokenStorageFile(File filename, Configuration conf) throws IOException {
        Credentials credentials;
        DataInputStream in = null;
        Credentials credentials2 = new Credentials();
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
            credentials2.readTokenStorageStream(in);
            credentials = credentials2;
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Exception reading " + filename, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, in);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, in);
        return credentials;
    }

    public void readTokenStorageStream(DataInputStream in) throws IOException {
        byte[] magic = new byte[TOKEN_STORAGE_MAGIC.length];
        in.readFully(magic);
        if (!Arrays.equals(magic, TOKEN_STORAGE_MAGIC)) {
            throw new IOException("Bad header found in token storage.");
        }
        byte version = in.readByte();
        if (version != 1 && version != 0) {
            throw new IOException("Unknown version " + version + " in token storage.");
        }
        if (version == 0) {
            this.readFields(in);
        } else if (version == 1) {
            this.readProto(in);
        }
    }

    public void writeTokenStorageToStream(DataOutputStream os) throws IOException {
        os.write(TOKEN_STORAGE_MAGIC);
        os.write(1);
        this.writeProto(os);
    }

    public void writeTokenStorageFile(Path filename, Configuration conf) throws IOException {
        FSDataOutputStream os = filename.getFileSystem(conf).create(filename);
        this.writeTokenStorageToStream(os);
        os.close();
    }

    public void writeLegacyTokenStorageLocalFile(File f) throws IOException {
        this.writeLegacyOutputStream(new DataOutputStream(new FileOutputStream(f)));
    }

    public void writeLegacyTokenStorageFile(Path filename, Configuration conf) throws IOException {
        this.writeLegacyOutputStream(filename.getFileSystem(conf).create(filename));
    }

    private void writeLegacyOutputStream(DataOutputStream os) throws IOException {
        os.write(TOKEN_STORAGE_MAGIC);
        os.write(0);
        this.write(os);
        os.close();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.tokenMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.tokenMap.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        WritableUtils.writeVInt(out, this.secretKeysMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.secretKeysMap.entrySet()) {
            entry.getKey().write(out);
            WritableUtils.writeVInt(out, ((byte[])entry.getValue()).length);
            out.write((byte[])entry.getValue());
        }
    }

    public void writeProto(DataOutput out) throws IOException {
        SecurityProtos.CredentialsKVProto.Builder kv;
        SecurityProtos.CredentialsProto.Builder storage = SecurityProtos.CredentialsProto.newBuilder();
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.tokenMap.entrySet()) {
            kv = SecurityProtos.CredentialsKVProto.newBuilder().setAliasBytes(ByteString.copyFrom((byte[])entry.getKey().getBytes(), (int)0, (int)entry.getKey().getLength())).setToken(entry.getValue().toTokenProto());
            storage.addTokens(kv.build());
        }
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.secretKeysMap.entrySet()) {
            kv = SecurityProtos.CredentialsKVProto.newBuilder().setAliasBytes(ByteString.copyFrom((byte[])entry.getKey().getBytes(), (int)0, (int)entry.getKey().getLength())).setSecret(ByteString.copyFrom((byte[])((byte[])entry.getValue())));
            storage.addSecrets(kv.build());
        }
        storage.build().writeDelimitedTo((DataOutputStream)out);
    }

    public void readProto(DataInput in) throws IOException {
        SecurityProtos.CredentialsProto storage = SecurityProtos.CredentialsProto.parseDelimitedFrom((DataInputStream)in);
        for (SecurityProtos.CredentialsKVProto kv : storage.getTokensList()) {
            this.addToken(new Text(kv.getAliasBytes().toByteArray()), new Token(kv.getToken()));
        }
        for (SecurityProtos.CredentialsKVProto kv : storage.getSecretsList()) {
            this.addSecretKey(new Text(kv.getAliasBytes().toByteArray()), kv.getSecret().toByteArray());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Text alias;
        int i;
        this.secretKeysMap.clear();
        this.tokenMap.clear();
        int size = WritableUtils.readVInt(in);
        for (i = 0; i < size; ++i) {
            alias = new Text();
            alias.readFields(in);
            Token t = new Token();
            t.readFields(in);
            this.tokenMap.put(alias, t);
        }
        size = WritableUtils.readVInt(in);
        for (i = 0; i < size; ++i) {
            alias = new Text();
            alias.readFields(in);
            int len = WritableUtils.readVInt(in);
            byte[] value = new byte[len];
            in.readFully(value);
            this.secretKeysMap.put(alias, value);
        }
    }

    public void addAll(Credentials other) {
        this.addAll(other, true);
    }

    public void mergeAll(Credentials other) {
        this.addAll(other, false);
    }

    private void addAll(Credentials other, boolean overwrite) {
        Text key;
        for (Map.Entry<Text, byte[]> entry : other.secretKeysMap.entrySet()) {
            key = entry.getKey();
            if (this.secretKeysMap.containsKey(key) && !overwrite) continue;
            this.secretKeysMap.put(key, entry.getValue());
        }
        for (Map.Entry<Text, Object> entry : other.tokenMap.entrySet()) {
            key = entry.getKey();
            if (this.tokenMap.containsKey(key) && !overwrite) continue;
            this.addToken(key, (Token)entry.getValue());
        }
    }
}

