/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.ErasureCodecOptions;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.codec.ErasureCodec;
import org.apache.hadoop.io.erasurecode.codec.HHXORErasureCodec;
import org.apache.hadoop.io.erasurecode.codec.RSErasureCodec;
import org.apache.hadoop.io.erasurecode.codec.XORErasureCodec;
import org.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawErasureCoderFactoryLegacy;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.XORRawErasureCoderFactory;

@InterfaceAudience.Private
public final class CodecUtil {
    public static final String IO_ERASURECODE_CODEC_XOR_KEY = "io.erasurecode.codec.xor";
    public static final String IO_ERASURECODE_CODEC_XOR = XORErasureCodec.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_RS_DEFAULT_KEY = "io.erasurecode.codec.rs";
    public static final String IO_ERASURECODE_CODEC_RS_DEFAULT = RSErasureCodec.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_HHXOR_KEY = "io.erasurecode.codec.hhxor";
    public static final String IO_ERASURECODE_CODEC_HHXOR = HHXORErasureCodec.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_RS_DEFAULT_RAWCODER_KEY = "io.erasurecode.codec.rs-default.rawcoder";
    public static final String IO_ERASURECODE_CODEC_RS_DEFAULT_RAWCODER_DEFAULT = RSRawErasureCoderFactory.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_RS_LEGACY_RAWCODER_KEY = "io.erasurecode.codec.rs-legacy.rawcoder";
    public static final String IO_ERASURECODE_CODEC_RS_LEGACY_RAWCODER_DEFAULT = RSRawErasureCoderFactoryLegacy.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_XOR_RAWCODER_KEY = "io.erasurecode.codec.xor.rawcoder";
    public static final String IO_ERASURECODE_CODEC_XOR_RAWCODER_DEFAULT = XORRawErasureCoderFactory.class.getCanonicalName();

    private CodecUtil() {
    }

    public static ErasureEncoder createEncoder(Configuration conf, ErasureCodecOptions options) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)options);
        String codecKey = CodecUtil.getCodecClassName(conf, options.getSchema().getCodecName());
        ErasureCodec codec = CodecUtil.createCodec(conf, codecKey, options);
        return codec.createEncoder();
    }

    public static ErasureDecoder createDecoder(Configuration conf, ErasureCodecOptions options) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)options);
        String codecKey = CodecUtil.getCodecClassName(conf, options.getSchema().getCodecName());
        ErasureCodec codec = CodecUtil.createCodec(conf, codecKey, options);
        return codec.createDecoder();
    }

    public static RawErasureEncoder createRawEncoder(Configuration conf, String codec, ErasureCoderOptions coderOptions) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)codec);
        String rawCoderFactoryKey = CodecUtil.getRawCoderFactNameFromCodec(conf, codec);
        RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(conf, rawCoderFactoryKey);
        return fact.createEncoder(coderOptions);
    }

    public static RawErasureDecoder createRawDecoder(Configuration conf, String codec, ErasureCoderOptions coderOptions) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)codec);
        String rawCoderFactoryKey = CodecUtil.getRawCoderFactNameFromCodec(conf, codec);
        RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(conf, rawCoderFactoryKey);
        return fact.createDecoder(coderOptions);
    }

    private static RawErasureCoderFactory createRawCoderFactory(Configuration conf, String rawCoderFactoryKey) {
        RawErasureCoderFactory fact;
        try {
            Class<RawErasureCoderFactory> factClass = conf.getClassByName(rawCoderFactoryKey).asSubclass(RawErasureCoderFactory.class);
            fact = factClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create raw coder factory", e);
        }
        if (fact == null) {
            throw new RuntimeException("Failed to create raw coder factory");
        }
        return fact;
    }

    private static String getRawCoderFactNameFromCodec(Configuration conf, String codec) {
        switch (codec) {
            case "rs-default": {
                return conf.get(IO_ERASURECODE_CODEC_RS_DEFAULT_RAWCODER_KEY, IO_ERASURECODE_CODEC_RS_DEFAULT_RAWCODER_DEFAULT);
            }
            case "rs-legacy": {
                return conf.get(IO_ERASURECODE_CODEC_RS_LEGACY_RAWCODER_KEY, IO_ERASURECODE_CODEC_RS_LEGACY_RAWCODER_DEFAULT);
            }
            case "xor": {
                return conf.get(IO_ERASURECODE_CODEC_XOR_RAWCODER_KEY, IO_ERASURECODE_CODEC_XOR_RAWCODER_DEFAULT);
            }
        }
        String rawCoderKey = "io.erasurecode.codec." + codec + ".rawcoder";
        String factName = conf.get(rawCoderKey);
        if (factName == null) {
            throw new IllegalArgumentException("Raw coder factory not configured for custom codec " + codec);
        }
        return factName;
    }

    private static ErasureCodec createCodec(Configuration conf, String codecClassName, ErasureCodecOptions options) {
        ErasureCodec codec = null;
        try {
            Class<ErasureCodec> codecClass = conf.getClassByName(codecClassName).asSubclass(ErasureCodec.class);
            Constructor<ErasureCodec> constructor = codecClass.getConstructor(Configuration.class, ErasureCodecOptions.class);
            codec = constructor.newInstance(conf, options);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create erasure codec", e);
        }
        if (codec == null) {
            throw new RuntimeException("Failed to create erasure codec");
        }
        return codec;
    }

    private static String getCodecClassName(Configuration conf, String codec) {
        switch (codec) {
            case "rs-default": {
                return conf.get(IO_ERASURECODE_CODEC_RS_DEFAULT_KEY, IO_ERASURECODE_CODEC_RS_DEFAULT);
            }
            case "rs-legacy": {
                return conf.get(IO_ERASURECODE_CODEC_RS_DEFAULT_KEY, IO_ERASURECODE_CODEC_RS_DEFAULT);
            }
            case "xor": {
                return conf.get(IO_ERASURECODE_CODEC_XOR_KEY, IO_ERASURECODE_CODEC_XOR);
            }
            case "hhxor": {
                return conf.get(IO_ERASURECODE_CODEC_HHXOR_KEY, IO_ERASURECODE_CODEC_HHXOR);
            }
        }
        String codecKey = "io.erasurecode.codec." + codec + ".coder";
        String codecClass = conf.get(codecKey);
        if (codecClass == null) {
            throw new IllegalArgumentException("Codec not configured for custom codec " + codec);
        }
        return codecClass;
    }
}

