/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class ErasureEncodingStep
implements ErasureCodingStep {
    private ECBlock[] inputBlocks;
    private ECBlock[] outputBlocks;
    private RawErasureEncoder rawEncoder;

    public ErasureEncodingStep(ECBlock[] inputBlocks, ECBlock[] outputBlocks, RawErasureEncoder rawEncoder) {
        this.inputBlocks = inputBlocks;
        this.outputBlocks = outputBlocks;
        this.rawEncoder = rawEncoder;
    }

    @Override
    public void performCoding(ECChunk[] inputChunks, ECChunk[] outputChunks) {
        this.rawEncoder.encode(inputChunks, outputChunks);
    }

    @Override
    public ECBlock[] getInputBlocks() {
        return this.inputBlocks;
    }

    @Override
    public ECBlock[] getOutputBlocks() {
        return this.outputBlocks;
    }

    @Override
    public void finish() {
        this.rawEncoder.release();
    }
}

