/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;
import org.apache.hadoop.io.compress.bzip2.CBZip2InputStream;
import org.apache.hadoop.io.compress.bzip2.CBZip2OutputStream;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class BZip2Codec
implements Configurable,
SplittableCompressionCodec {
    private static final String HEADER = "BZ";
    private static final int HEADER_LEN = "BZ".length();
    private static final String SUB_HEADER = "h9";
    private static final int SUB_HEADER_LEN = "h9".length();
    private Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return Bzip2Factory.isNativeBzip2Loaded(this.conf) ? new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096)) : new BZip2CompressionOutputStream(out);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return Bzip2Factory.getBzip2CompressorType(this.conf);
    }

    @Override
    public Compressor createCompressor() {
        return Bzip2Factory.getBzip2Compressor(this.conf);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return Bzip2Factory.isNativeBzip2Loaded(this.conf) ? new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096)) : new BZip2CompressionInputStream(in);
    }

    @Override
    public SplitCompressionInputStream createInputStream(InputStream seekableIn, Decompressor decompressor, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
        if (!(seekableIn instanceof Seekable)) {
            throw new IOException("seekableIn must be an instance of " + Seekable.class.getName());
        }
        ((Seekable)((Object)seekableIn)).seek(0L);
        long FIRST_BZIP2_BLOCK_MARKER_POSITION = CBZip2InputStream.numberOfBytesTillNextMarker(seekableIn);
        long adjStart = 0L;
        if (start != 0L) {
            adjStart = Math.max(0L, start - (FIRST_BZIP2_BLOCK_MARKER_POSITION - (long)(HEADER_LEN + SUB_HEADER_LEN)));
        }
        ((Seekable)((Object)seekableIn)).seek(adjStart);
        BZip2CompressionInputStream in = new BZip2CompressionInputStream(seekableIn, adjStart, end, readMode);
        if (((CompressionInputStream)in).getPos() < start) {
            ((Seekable)((Object)seekableIn)).seek(start);
            in = new BZip2CompressionInputStream(seekableIn, start, end, readMode);
        }
        return in;
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return Bzip2Factory.getBzip2DecompressorType(this.conf);
    }

    @Override
    public Decompressor createDecompressor() {
        return Bzip2Factory.getBzip2Decompressor(this.conf);
    }

    @Override
    public String getDefaultExtension() {
        return ".bz2";
    }

    private static class BZip2CompressionInputStream
    extends SplitCompressionInputStream {
        private CBZip2InputStream input;
        boolean needsReset = false;
        private BufferedInputStream bufferedIn;
        private boolean isHeaderStripped = false;
        private boolean isSubHeaderStripped = false;
        private SplittableCompressionCodec.READ_MODE readMode = SplittableCompressionCodec.READ_MODE.CONTINUOUS;
        private long startingPos = 0L;
        POS_ADVERTISEMENT_STATE_MACHINE posSM = POS_ADVERTISEMENT_STATE_MACHINE.HOLD;
        long compressedStreamPosition = 0L;

        public BZip2CompressionInputStream(InputStream in) throws IOException {
            this(in, 0L, Long.MAX_VALUE, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
        }

        public BZip2CompressionInputStream(InputStream in, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
            super(in, start, end);
            this.bufferedIn = new BufferedInputStream(this.in);
            this.startingPos = super.getPos();
            this.readMode = readMode;
            if (this.startingPos == 0L) {
                this.bufferedIn = this.readStreamHeader();
            }
            this.input = new CBZip2InputStream(this.bufferedIn, readMode);
            if (this.isHeaderStripped) {
                this.input.updateReportedByteCount(HEADER_LEN);
            }
            if (this.isSubHeaderStripped) {
                this.input.updateReportedByteCount(SUB_HEADER_LEN);
            }
            this.updatePos(false);
        }

        private BufferedInputStream readStreamHeader() throws IOException {
            if (this.in != null) {
                this.bufferedIn.mark(HEADER_LEN);
                byte[] headerBytes = new byte[HEADER_LEN];
                int actualRead = this.bufferedIn.read(headerBytes, 0, HEADER_LEN);
                if (actualRead != -1) {
                    String header = new String(headerBytes, StandardCharsets.UTF_8);
                    if (header.compareTo(BZip2Codec.HEADER) != 0) {
                        this.bufferedIn.reset();
                    } else {
                        this.isHeaderStripped = true;
                        if (this.readMode == SplittableCompressionCodec.READ_MODE.BYBLOCK && (actualRead = this.bufferedIn.read(headerBytes, 0, SUB_HEADER_LEN)) != -1) {
                            this.isSubHeaderStripped = true;
                        }
                    }
                }
            }
            if (this.bufferedIn == null) {
                throw new IOException("Failed to read bzip2 stream.");
            }
            return this.bufferedIn;
        }

        @Override
        public void close() throws IOException {
            if (!this.needsReset) {
                this.input.close();
                this.needsReset = true;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            int result = 0;
            result = this.input.read(b, off, len);
            if (result == -2) {
                this.posSM = POS_ADVERTISEMENT_STATE_MACHINE.ADVERTISE;
            }
            if (this.posSM == POS_ADVERTISEMENT_STATE_MACHINE.ADVERTISE) {
                result = this.input.read(b, off, off + 1);
                this.updatePos(true);
                this.posSM = POS_ADVERTISEMENT_STATE_MACHINE.HOLD;
            }
            return result;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int result = this.read(b, 0, 1);
            return result < 0 ? result : b[0] & 0xFF;
        }

        private void internalReset() throws IOException {
            if (this.needsReset) {
                this.needsReset = false;
                BufferedInputStream bufferedIn = this.readStreamHeader();
                this.input = new CBZip2InputStream(bufferedIn, this.readMode);
            }
        }

        @Override
        public void resetState() throws IOException {
            this.needsReset = true;
        }

        @Override
        public long getPos() {
            return this.compressedStreamPosition;
        }

        private void updatePos(boolean shouldAddOn) {
            int addOn = shouldAddOn ? 1 : 0;
            this.compressedStreamPosition = this.startingPos + this.input.getProcessedByteCount() + (long)addOn;
        }

        private static enum POS_ADVERTISEMENT_STATE_MACHINE {
            HOLD,
            ADVERTISE;

        }
    }

    private static class BZip2CompressionOutputStream
    extends CompressionOutputStream {
        private CBZip2OutputStream output;
        private boolean needsReset = true;

        public BZip2CompressionOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        private void writeStreamHeader() throws IOException {
            if (this.out != null) {
                this.out.write(BZip2Codec.HEADER.getBytes(StandardCharsets.UTF_8));
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.finish();
            this.needsReset = true;
        }

        private void internalReset() throws IOException {
            if (this.needsReset) {
                this.needsReset = false;
                this.writeStreamHeader();
                this.output = new CBZip2OutputStream(this.out);
            }
        }

        @Override
        public void resetState() throws IOException {
            this.needsReset = true;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.flush();
            this.output.close();
            this.needsReset = true;
        }
    }
}

