/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class AuthenticationWithProxyUserFilter
extends AuthenticationFilter {
    public static final Log LOG = LogFactory.getLog(AuthenticationWithProxyUserFilter.class);
    private static final String DO_AS = "doAs";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        final String proxyUser = AuthenticationWithProxyUserFilter.getDoAs(request);
        if (proxyUser != null) {
            final HttpServletRequest finalReq = request;
            request = new HttpServletRequestWrapper(finalReq){

                private String getRemoteOrProxyUser() throws AuthorizationException {
                    UserGroupInformation realUser = UserGroupInformation.createRemoteUser(finalReq.getRemoteUser());
                    UserGroupInformation proxyUserInfo = UserGroupInformation.createProxyUser(proxyUser, realUser);
                    ProxyUsers.authorize(proxyUserInfo, finalReq.getRemoteAddr());
                    return proxyUserInfo.getUserName();
                }

                public String getRemoteUser() {
                    try {
                        return this.getRemoteOrProxyUser();
                    }
                    catch (AuthorizationException ex) {
                        LOG.error((Object)("Unable to verify proxy user: " + ex.getMessage()), (Throwable)ex);
                        return null;
                    }
                }
            };
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static String getDoAs(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        List list = URLEncodedUtils.parse((String)queryString, (Charset)UTF8_CHARSET);
        if (list != null) {
            for (NameValuePair nv : list) {
                if (!DO_AS.equalsIgnoreCase(nv.getName())) continue;
                return nv.getValue();
            }
        }
        return null;
    }
}

