/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.google.common.base.Supplier;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMutableRollingAverages {
    @Test(timeout=30000L)
    public void testRollingAveragesEmptyRollover() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        try (MutableRollingAverages rollingAverages = new MutableRollingAverages("Time");){
            rollingAverages.replaceScheduledTask(2, 5L, TimeUnit.SECONDS);
            rollingAverages.snapshot(rb, true);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"FooRollingAvgTime", (String)"Rolling average time for foo"), 0L);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"BarAvgTime", (String)"Rolling average time for bar"), 0L);
            Thread.sleep(6000L);
            rollingAverages.snapshot(rb, false);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"FooRollingAvgTime", (String)"Rolling average time for foo"), 0L);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"BarAvgTime", (String)"Rolling average time for bar"), 0L);
        }
    }

    @Test(timeout=30000L)
    public void testRollingAveragesRollover() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        String name = "foo2";
        int windowSizeMs = 5000;
        int numWindows = 2;
        int numOpsPerIteration = 1000;
        try (MutableRollingAverages rollingAverages = new MutableRollingAverages("Time");){
            rollingAverages.replaceScheduledTask(2, 5000L, TimeUnit.MILLISECONDS);
            long start = Time.monotonicNow();
            for (int i = 1; i <= 3; ++i) {
                for (long j = 1L; j <= 1000L; ++j) {
                    rollingAverages.add("foo2", (long)i);
                }
                long sleep = start + (long)(5000 * i) + 1000L - Time.monotonicNow();
                Thread.sleep(sleep);
                rollingAverages.snapshot(rb, false);
                double rollingSum = 1000 * (i > 1 ? i - 1 : 0) + 1000 * i;
                long rollingTotal = i > 1 ? 2000L : 1000L;
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"[Foo2]RollingAvgTime", (String)"Rolling average time for foo2"), rollingSum / (double)rollingTotal);
                ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)i))).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"[Foo2]RollingAvgTime", (String)"Rolling average time for foo2")), Matchers.anyDouble());
            }
        }
    }

    @Test(timeout=30000L)
    public void testMutableRollingAveragesMetric() throws Exception {
        final DummyTestMetric testMetric = new DummyTestMetric();
        testMetric.create();
        testMetric.add("metric1", 100L);
        testMetric.add("metric1", 900L);
        testMetric.add("metric2", 1000L);
        testMetric.add("metric2", 1000L);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                testMetric.collectThreadLocalStates();
                return testMetric.getStats().size() > 0;
            }
        }, 500L, 5000L);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("RollingAveragesTestMetric");
        double metric1Avg = MetricsAsserts.getDoubleGauge("[Metric1]RollingAvgTesting", rb);
        double metric2Avg = MetricsAsserts.getDoubleGauge("[Metric2]RollingAvgTesting", rb);
        Assert.assertTrue((String)"The rolling average of metric1 is not as expected", (metric1Avg == 500.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The rolling average of metric2 is not as expected", (metric2Avg == 1000.0 ? 1 : 0) != 0);
    }

    class DummyTestMetric {
        @Metric(valueName="testing")
        private MutableRollingAverages rollingAverages;
        static final String METRIC_NAME = "RollingAveragesTestMetric";

        DummyTestMetric() {
        }

        protected void create() {
            DefaultMetricsSystem.instance().register(METRIC_NAME, "mutable rolling averages test", (Object)this);
            this.rollingAverages.replaceScheduledTask(10, 1000L, TimeUnit.MILLISECONDS);
        }

        void add(String name, long latency) {
            this.rollingAverages.add(name, latency);
        }

        void collectThreadLocalStates() {
            this.rollingAverages.collectThreadLocalStates();
        }

        Map<String, Double> getStats() {
            return this.rollingAverages.getStats(0L);
        }
    }
}

