/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.NodeHealthScriptRunner;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeHealthScriptRunner {
    protected static File testRootDir = new File("target", TestNodeHealthScriptRunner.class.getName() + "-localDir").getAbsoluteFile();
    private File nodeHealthscriptFile = new File(testRootDir, Shell.appendScriptExtension((String)"failingscript"));

    @Before
    public void setup() {
        testRootDir.mkdirs();
    }

    @After
    public void tearDown() throws Exception {
        if (testRootDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(testRootDir.getAbsolutePath()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeHealthScriptFile(String scriptStr, boolean setExecutable) throws IOException {
        try (PrintWriter pw = null;){
            FileUtil.setWritable((File)this.nodeHealthscriptFile, (boolean)true);
            FileUtil.setReadable((File)this.nodeHealthscriptFile, (boolean)true);
            pw = new PrintWriter(new FileOutputStream(this.nodeHealthscriptFile));
            pw.println(scriptStr);
            pw.flush();
        }
        FileUtil.setExecutable((File)this.nodeHealthscriptFile, (boolean)setExecutable);
    }

    @Test
    public void testNodeHealthScriptShouldRun() throws IOException {
        Assert.assertFalse((String)"Node health script should start", (boolean)NodeHealthScriptRunner.shouldRun((String)this.nodeHealthscriptFile.getAbsolutePath()));
        this.writeNodeHealthScriptFile("", false);
        Assert.assertFalse((String)"Node health script should start", (boolean)NodeHealthScriptRunner.shouldRun((String)this.nodeHealthscriptFile.getAbsolutePath()));
        this.writeNodeHealthScriptFile("", true);
        Assert.assertTrue((String)"Node health script should start", (boolean)NodeHealthScriptRunner.shouldRun((String)this.nodeHealthscriptFile.getAbsolutePath()));
    }

    @Test
    public void testNodeHealthScript() throws Exception {
        String errorScript = "echo ERROR\n echo \"Tracker not healthy\"";
        String normalScript = "echo \"I am all fine\"";
        String timeOutScript = Shell.WINDOWS ? "@echo off\nping -n 4 127.0.0.1 >nul\necho \"I am fine\"" : "sleep 4\necho \"I am fine\"";
        String exitCodeScript = "exit 127";
        Configuration conf = new Configuration();
        this.writeNodeHealthScriptFile(normalScript, true);
        NodeHealthScriptRunner nodeHealthScriptRunner = new NodeHealthScriptRunner(this.nodeHealthscriptFile.getAbsolutePath(), 500L, 1000L, new String[0]);
        nodeHealthScriptRunner.init(conf);
        TimerTask timerTask = nodeHealthScriptRunner.getTimerTask();
        timerTask.run();
        Assert.assertTrue((String)"Node health status reported unhealthy", (boolean)nodeHealthScriptRunner.isHealthy());
        Assert.assertEquals((Object)"", (Object)nodeHealthScriptRunner.getHealthReport());
        this.writeNodeHealthScriptFile(errorScript, true);
        timerTask.run();
        Assert.assertFalse((String)"Node health status reported healthy", (boolean)nodeHealthScriptRunner.isHealthy());
        Assert.assertTrue((boolean)nodeHealthScriptRunner.getHealthReport().contains("ERROR"));
        this.writeNodeHealthScriptFile(normalScript, true);
        timerTask.run();
        Assert.assertTrue((String)"Node health status reported unhealthy", (boolean)nodeHealthScriptRunner.isHealthy());
        Assert.assertEquals((Object)"", (Object)nodeHealthScriptRunner.getHealthReport());
        this.writeNodeHealthScriptFile(timeOutScript, true);
        timerTask.run();
        Assert.assertFalse((String)"Node health status reported healthy even after timeout", (boolean)nodeHealthScriptRunner.isHealthy());
        Assert.assertEquals((Object)"Node health script timed out", (Object)nodeHealthScriptRunner.getHealthReport());
        this.writeNodeHealthScriptFile(exitCodeScript, true);
        timerTask.run();
        Assert.assertTrue((String)"Node health status reported unhealthy", (boolean)nodeHealthScriptRunner.isHealthy());
        Assert.assertEquals((Object)"", (Object)nodeHealthScriptRunner.getHealthReport());
    }
}

