/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.IsActiveServlet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIsActiveServlet {
    private IsActiveServlet servlet;
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private ByteArrayOutputStream respOut;

    @Before
    public void setUp() throws Exception {
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.respOut = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(this.respOut);
        Mockito.when((Object)this.resp.getWriter()).thenReturn((Object)writer);
    }

    @Test
    public void testSucceedsOnActive() throws IOException {
        this.servlet = new IsActiveServlet(){

            protected boolean isActive() {
                return true;
            }
        };
        String response = this.doGet();
        ((HttpServletResponse)Mockito.verify((Object)this.resp, (VerificationMode)Mockito.never())).sendError(Matchers.anyInt(), Matchers.anyString());
        Assert.assertEquals((Object)"I am Active!", (Object)response);
    }

    @Test
    public void testFailsOnInactive() throws IOException {
        this.servlet = new IsActiveServlet(){

            protected boolean isActive() {
                return false;
            }
        };
        this.doGet();
        ((HttpServletResponse)Mockito.verify((Object)this.resp, (VerificationMode)Mockito.atLeastOnce())).sendError(Matchers.eq((int)405), (String)Matchers.eq((Object)"I am not Active!"));
    }

    private String doGet() throws IOException {
        this.servlet.doGet(this.req, this.resp);
        return new String(this.respOut.toByteArray(), "UTF-8");
    }
}

