/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.util.Time;
import org.junit.Assert;

public class TestRpcBase {
    protected static final String SERVER_PRINCIPAL_KEY = "test.ipc.server.principal";
    protected static final String CLIENT_PRINCIPAL_KEY = "test.ipc.client.principal";
    protected static final String ADDRESS = "0.0.0.0";
    protected static final int PORT = 0;
    protected static InetSocketAddress addr;
    protected static Configuration conf;

    protected void setupConf() {
        conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    protected static RPC.Builder newServerBuilder(Configuration serverConf) throws IOException {
        PBServerImpl serverImpl = new PBServerImpl();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(serverImpl);
        RPC.Builder builder = new RPC.Builder(serverConf).setProtocol(TestRpcService.class).setInstance((Object)service).setBindAddress(ADDRESS).setPort(0);
        return builder;
    }

    protected static RPC.Server setupTestServer(Configuration serverConf, int numHandlers) throws IOException {
        return TestRpcBase.setupTestServer(serverConf, numHandlers, null);
    }

    protected static RPC.Server setupTestServer(Configuration serverConf, int numHandlers, SecretManager<?> serverSm) throws IOException {
        RPC.Builder builder = TestRpcBase.newServerBuilder(serverConf);
        if (numHandlers > 0) {
            builder.setNumHandlers(numHandlers);
        }
        if (serverSm != null) {
            builder.setSecretManager(serverSm);
        }
        return TestRpcBase.setupTestServer(builder);
    }

    protected static RPC.Server setupTestServer(RPC.Builder builder) throws IOException {
        RPC.Server server = builder.build();
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        return server;
    }

    protected static TestRpcService getClient(InetSocketAddress serverAddr, Configuration clientConf) throws ServiceException {
        try {
            return (TestRpcService)RPC.getProxy(TestRpcService.class, (long)0L, (InetSocketAddress)serverAddr, (Configuration)clientConf);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected static TestRpcService getClient(InetSocketAddress serverAddr, Configuration clientConf, RetryPolicy connectionRetryPolicy) throws ServiceException {
        try {
            return (TestRpcService)RPC.getProtocolProxy(TestRpcService.class, (long)0L, (InetSocketAddress)serverAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)clientConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)clientConf), (int)RPC.getRpcTimeout((Configuration)clientConf), (RetryPolicy)connectionRetryPolicy, null).getProxy();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected static void stop(Server server, TestRpcService proxy) {
        if (proxy != null) {
            try {
                RPC.stopProxy((Object)proxy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static int countThreads(String search) {
        ThreadInfo[] infos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        int count = 0;
        block0: for (ThreadInfo info : infos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 20)) {
            if (info == null) continue;
            for (StackTraceElement elem : info.getStackTrace()) {
                if (!elem.getClassName().contains(search)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static TestProtos.EmptyRequestProto newEmptyRequest() {
        return TestProtos.EmptyRequestProto.newBuilder().build();
    }

    protected static TestProtos.EmptyResponseProto newEmptyResponse() {
        return TestProtos.EmptyResponseProto.newBuilder().build();
    }

    protected static TestProtos.EchoRequestProto newEchoRequest(String msg) {
        return TestProtos.EchoRequestProto.newBuilder().setMessage(msg).build();
    }

    protected static String convert(TestProtos.EchoResponseProto response) {
        return response.getMessage();
    }

    protected static TestProtos.SlowPingRequestProto newSlowPingRequest(boolean shouldSlow) throws ServiceException {
        return TestProtos.SlowPingRequestProto.newBuilder().setShouldSlow(shouldSlow).build();
    }

    protected static TestProtos.SleepRequestProto newSleepRequest(int milliSeconds) {
        return TestProtos.SleepRequestProto.newBuilder().setMilliSeconds(milliSeconds).build();
    }

    protected static TestProtos.EchoResponseProto newEchoResponse(String msg) {
        return TestProtos.EchoResponseProto.newBuilder().setMessage(msg).build();
    }

    protected static SaslRpcServer.AuthMethod convert(TestProtos.AuthMethodResponseProto authMethodResponse) {
        String mechanism = authMethodResponse.getMechanismName();
        if (mechanism.equals(SaslRpcServer.AuthMethod.SIMPLE.getMechanismName())) {
            return SaslRpcServer.AuthMethod.SIMPLE;
        }
        if (mechanism.equals(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName())) {
            return SaslRpcServer.AuthMethod.KERBEROS;
        }
        if (mechanism.equals(SaslRpcServer.AuthMethod.TOKEN.getMechanismName())) {
            return SaslRpcServer.AuthMethod.TOKEN;
        }
        return null;
    }

    public static class PBServerImpl
    implements TestRpcService {
        CountDownLatch fastPingCounter = new CountDownLatch(2);
        private List<Server.Call> postponedCalls = new ArrayList<Server.Call>();
        private final Lock lock = new ReentrantLock();

        @Override
        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assert.assertNotNull((Object)clientId);
            Assert.assertEquals((long)16L, (long)clientId.length);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EchoResponseProto echo(RpcController unused, TestProtos.EchoRequestProto request) throws ServiceException {
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }

        @Override
        public TestProtos.EmptyResponseProto error(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            throw new ServiceException("error", (Throwable)new RpcServerException("error"));
        }

        @Override
        public TestProtos.EmptyResponseProto error2(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            throw new ServiceException("error", (Throwable)new URISyntaxException("", "testException"));
        }

        @Override
        public TestProtos.EmptyResponseProto slowPing(RpcController unused, TestProtos.SlowPingRequestProto request) throws ServiceException {
            boolean shouldSlow = request.getShouldSlow();
            if (shouldSlow) {
                try {
                    this.fastPingCounter.await();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.fastPingCounter.countDown();
            }
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EchoResponseProto2 echo2(RpcController controller, TestProtos.EchoRequestProto2 request) throws ServiceException {
            return TestProtos.EchoResponseProto2.newBuilder().addAllMessage((Iterable<String>)request.getMessageList()).build();
        }

        @Override
        public TestProtos.AddResponseProto add(RpcController controller, TestProtos.AddRequestProto request) throws ServiceException {
            return TestProtos.AddResponseProto.newBuilder().setResult(request.getParam1() + request.getParam2()).build();
        }

        @Override
        public TestProtos.AddResponseProto add2(RpcController controller, TestProtos.AddRequestProto2 request) throws ServiceException {
            int sum = 0;
            for (Integer num : request.getParamsList()) {
                sum += num.intValue();
            }
            return TestProtos.AddResponseProto.newBuilder().setResult(sum).build();
        }

        @Override
        public TestProtos.EmptyResponseProto testServerGet(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            if (!(Server.get() instanceof RPC.Server)) {
                throw new ServiceException("Server.get() failed");
            }
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.ExchangeResponseProto exchange(RpcController controller, TestProtos.ExchangeRequestProto request) throws ServiceException {
            Integer[] values = new Integer[request.getValuesCount()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = i;
            }
            return TestProtos.ExchangeResponseProto.newBuilder().addAllValues(Arrays.asList(values)).build();
        }

        @Override
        public TestProtos.EmptyResponseProto sleep(RpcController controller, TestProtos.SleepRequestProto request) throws ServiceException {
            try {
                Thread.sleep(request.getMilliSeconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TestProtos.EmptyResponseProto lockAndSleep(RpcController controller, TestProtos.SleepRequestProto request) throws ServiceException {
            ProcessingDetails details = ((Server.Call)Server.getCurCall().get()).getProcessingDetails();
            this.lock.lock();
            long startNanos = Time.monotonicNowNanos();
            try {
                Thread.sleep(request.getMilliSeconds());
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.unlock();
            }
            details.add(ProcessingDetails.Timing.LOCKWAIT, 10L, TimeUnit.SECONDS);
            details.add(ProcessingDetails.Timing.LOCKEXCLUSIVE, Time.monotonicNowNanos() - startNanos, TimeUnit.NANOSECONDS);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.AuthMethodResponseProto getAuthMethod(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            SaslRpcServer.AuthMethod authMethod = null;
            try {
                authMethod = UserGroupInformation.getCurrentUser().getAuthenticationMethod().getAuthMethod();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            return TestProtos.AuthMethodResponseProto.newBuilder().setCode(authMethod.code).setMechanismName(authMethod.getMechanismName()).build();
        }

        @Override
        public TestProtos.UserResponseProto getAuthUser(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            UserGroupInformation authUser;
            try {
                authUser = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            return this.newUserResponse(authUser.getUserName());
        }

        @Override
        public TestProtos.EchoResponseProto echoPostponed(RpcController controller, TestProtos.EchoRequestProto request) throws ServiceException {
            Server.Call call = (Server.Call)Server.getCurCall().get();
            call.postponeResponse();
            this.postponedCalls.add(call);
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }

        @Override
        public TestProtos.EmptyResponseProto sendPostponed(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            Collections.shuffle(this.postponedCalls);
            try {
                for (Server.Call call : this.postponedCalls) {
                    call.sendResponse();
                }
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            this.postponedCalls.clear();
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.UserResponseProto getCurrentUser(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            String user;
            try {
                user = UserGroupInformation.getCurrentUser().toString();
            }
            catch (IOException e) {
                throw new ServiceException("Failed to get current user", (Throwable)e);
            }
            return this.newUserResponse(user);
        }

        @Override
        public TestProtos.UserResponseProto getServerRemoteUser(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            String serverRemoteUser = Server.getRemoteUser().toString();
            return this.newUserResponse(serverRemoteUser);
        }

        private TestProtos.UserResponseProto newUserResponse(String user) {
            return TestProtos.UserResponseProto.newBuilder().setUser(user).build();
        }
    }

    @KerberosInfo(serverPrincipal="test.ipc.server.principal", clientPrincipal="test.ipc.client.principal")
    @TokenInfo(value=TestTokenSelector.class)
    @ProtocolInfo(protocolName="org.apache.hadoop.ipc.TestRpcBase$TestRpcService", protocolVersion=1L)
    public static interface TestRpcService
    extends TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface {
    }

    public static class TestTokenSelector
    implements TokenSelector<TestTokenIdentifier> {
        public Token<TestTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
            if (service == null) {
                return null;
            }
            for (Token<? extends TokenIdentifier> token : tokens) {
                if (!TestTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
                return token;
            }
            return null;
        }
    }

    public static class TestTokenSecretManager
    extends SecretManager<TestTokenIdentifier> {
        public byte[] createPassword(TestTokenIdentifier id) {
            return id.getBytes();
        }

        public byte[] retrievePassword(TestTokenIdentifier id) throws SecretManager.InvalidToken {
            return id.getBytes();
        }

        public TestTokenIdentifier createIdentifier() {
            return new TestTokenIdentifier();
        }
    }

    public static class TestTokenIdentifier
    extends TokenIdentifier {
        private Text tokenid;
        private Text realUser;
        static final Text KIND_NAME = new Text("test.token");

        public TestTokenIdentifier() {
            this(new Text(), new Text());
        }

        public TestTokenIdentifier(Text tokenid) {
            this(tokenid, new Text());
        }

        public TestTokenIdentifier(Text tokenid, Text realUser) {
            this.tokenid = tokenid == null ? new Text() : tokenid;
            this.realUser = realUser == null ? new Text() : realUser;
        }

        public Text getKind() {
            return KIND_NAME;
        }

        public UserGroupInformation getUser() {
            if (this.realUser.toString().isEmpty()) {
                return UserGroupInformation.createRemoteUser((String)this.tokenid.toString());
            }
            UserGroupInformation realUgi = UserGroupInformation.createRemoteUser((String)this.realUser.toString());
            return UserGroupInformation.createProxyUser((String)this.tokenid.toString(), (UserGroupInformation)realUgi);
        }

        public void readFields(DataInput in) throws IOException {
            this.tokenid.readFields(in);
            this.realUser.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.tokenid.write(out);
            this.realUser.write(out);
        }
    }
}

