/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.LimitInputStream;
import org.junit.Test;

public class TestLimitInputStream
extends HadoopTestBase {
    @Test
    public void testRead() throws IOException {
        try (LimitInputStream limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 0L);){
            TestLimitInputStream.assertEquals((String)"Reading byte after reaching limit should return -1", (long)-1L, (long)limitInputStream.read());
        }
        limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 4L);
        var2_2 = null;
        try {
            TestLimitInputStream.assertEquals((String)"Incorrect byte returned", (long)new Random(0L).nextInt(), (long)limitInputStream.read());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (limitInputStream != null) {
                if (var2_2 != null) {
                    try {
                        limitInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    limitInputStream.close();
                }
            }
        }
    }

    @Test(expected=IOException.class)
    public void testResetWithoutMark() throws IOException {
        try (LimitInputStream limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 128L);){
            limitInputStream.reset();
        }
    }

    @Test
    public void testReadBytes() throws IOException {
        try (LimitInputStream limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 128L);){
            Random r = new Random(0L);
            byte[] data = new byte[4];
            byte[] expected = new byte[]{(byte)r.nextInt(), (byte)r.nextInt(), (byte)r.nextInt(), (byte)r.nextInt()};
            limitInputStream.read(data, 0, 4);
            TestLimitInputStream.assertArrayEquals((String)"Incorrect bytes returned", (byte[])expected, (byte[])data);
        }
    }

    static class RandomInputStream
    extends InputStream {
        private Random rn = new Random(0L);

        RandomInputStream() {
        }

        @Override
        public int read() {
            return this.rn.nextInt();
        }
    }
}

