/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred.lib;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.StubContext;
import org.apache.hadoop.tools.mapred.lib.DynamicInputFormat;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDynamicInputFormat {
    private static final Log LOG = LogFactory.getLog(TestDynamicInputFormat.class);
    private static MiniDFSCluster cluster;
    private static final int N_FILES = 1000;
    private static final int NUM_SPLITS = 7;
    private static final Credentials CREDENTIALS;
    private static List<String> expectedFilePaths;

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster.Builder(TestDynamicInputFormat.getConfigurationForCluster()).numDataNodes(1).format(true).build();
        for (int i = 0; i < 1000; ++i) {
            TestDynamicInputFormat.createFile((String)("/tmp/source/" + String.valueOf(i)));
        }
    }

    private static Configuration getConfigurationForCluster() {
        Configuration configuration = new Configuration();
        System.setProperty("test.build.data", "target/tmp/build/TEST_DYNAMIC_INPUT_FORMAT/data");
        configuration.set("hadoop.log.dir", "target/tmp");
        LOG.debug((Object)("fs.default.name  == " + configuration.get("fs.default.name")));
        LOG.debug((Object)("dfs.http.address == " + configuration.get("dfs.http.address")));
        return configuration;
    }

    private static DistCpOptions getOptions() throws Exception {
        Path sourcePath = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/source");
        Path targetPath = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/target");
        ArrayList<Path> sourceList = new ArrayList<Path>();
        sourceList.add(sourcePath);
        DistCpOptions options = new DistCpOptions(sourceList, targetPath);
        options.setMaxMaps(7);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFile(String path) throws Exception {
        FileSystem fileSystem = null;
        FSDataOutputStream outputStream = null;
        try {
            fileSystem = cluster.getFileSystem();
            outputStream = fileSystem.create(new Path(path), true, 0);
            expectedFilePaths.add(fileSystem.listStatus(new Path(path))[0].getPath().toString());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    @Test
    public void testGetSplits() throws Exception {
        DistCpOptions options = TestDynamicInputFormat.getOptions();
        Configuration configuration = new Configuration();
        configuration.set("mapred.map.tasks", String.valueOf(options.getMaxMaps()));
        CopyListing.getCopyListing((Configuration)configuration, (Credentials)CREDENTIALS, (DistCpOptions)options).buildListing(new Path(cluster.getFileSystem().getUri().toString() + "/tmp/testDynInputFormat/fileList.seq"), options);
        JobContextImpl jobContext = new JobContextImpl(configuration, new JobID());
        DynamicInputFormat inputFormat = new DynamicInputFormat();
        List splits = inputFormat.getSplits((JobContext)jobContext);
        int nFiles = 0;
        int taskId = 0;
        for (InputSplit split : splits) {
            RecordReader recordReader = inputFormat.createRecordReader(split, null);
            StubContext stubContext = new StubContext(jobContext.getConfiguration(), recordReader, taskId);
            Mapper.Context taskAttemptContext = stubContext.getContext();
            recordReader.initialize((InputSplit)splits.get(0), (TaskAttemptContext)taskAttemptContext);
            float previousProgressValue = 0.0f;
            while (recordReader.nextKeyValue()) {
                FileStatus fileStatus = (FileStatus)recordReader.getCurrentValue();
                String source = fileStatus.getPath().toString();
                System.out.println(source);
                Assert.assertTrue((boolean)expectedFilePaths.contains(source));
                float progress = recordReader.getProgress();
                Assert.assertTrue((progress >= previousProgressValue ? 1 : 0) != 0);
                Assert.assertTrue((progress >= 0.0f ? 1 : 0) != 0);
                Assert.assertTrue((progress <= 1.0f ? 1 : 0) != 0);
                previousProgressValue = progress;
                ++nFiles;
            }
            Assert.assertTrue((recordReader.getProgress() == 1.0f ? 1 : 0) != 0);
            ++taskId;
        }
        Assert.assertEquals((int)expectedFilePaths.size(), (int)nFiles);
    }

    @Test
    public void testGetSplitRatio() throws Exception {
        Assert.assertEquals((int)1, (int)DynamicInputFormat.getSplitRatio((int)1, (int)1000000000));
        Assert.assertEquals((int)2, (int)DynamicInputFormat.getSplitRatio((int)11000000, (int)10));
        Assert.assertEquals((int)4, (int)DynamicInputFormat.getSplitRatio((int)30, (int)700));
        Assert.assertEquals((int)2, (int)DynamicInputFormat.getSplitRatio((int)30, (int)200));
    }

    static {
        CREDENTIALS = new Credentials();
        expectedFilePaths = new ArrayList(1000);
    }
}

