/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.SimpleCopyListing;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCopyListing
extends SimpleCopyListing {
    private static final Log LOG = LogFactory.getLog(TestCopyListing.class);
    private static final Credentials CREDENTIALS = new Credentials();
    private static final Configuration config = new Configuration();
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void create() throws IOException {
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).format(true).build();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public TestCopyListing() {
        super(config, CREDENTIALS);
    }

    protected TestCopyListing(Configuration configuration) {
        super(configuration, CREDENTIALS);
    }

    protected long getBytesToCopy() {
        return 0L;
    }

    protected long getNumberOfPaths() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSrcToFile() {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            srcPaths.add(new Path("/tmp/in/1"));
            srcPaths.add(new Path("/tmp/in/2"));
            Path target = new Path("/tmp/out/1");
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in/1");
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in/2");
            fs.mkdirs(target);
            DistCpOptions options = new DistCpOptions(srcPaths, target);
            this.validatePaths(options);
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
            target = new Path("/tmp/out/1");
            fs.create(target).close();
            options = new DistCpOptions(srcPaths, target);
            try {
                this.validatePaths(options);
                Assert.fail((String)"Invalid inputs accepted");
            }
            catch (CopyListing.InvalidInputException ignore) {
                // empty catch block
            }
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
            srcPaths.clear();
            srcPaths.add(new Path("/tmp/in/1"));
            fs.mkdirs(new Path("/tmp/in/1"));
            target = new Path("/tmp/out/1");
            fs.create(target).close();
            options = new DistCpOptions(srcPaths, target);
            try {
                this.validatePaths(options);
                Assert.fail((String)"Invalid inputs accepted");
            }
            catch (CopyListing.InvalidInputException ignore) {
                // empty catch block
            }
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)"Test input validation failed");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicates() {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            srcPaths.add(new Path("/tmp/in/*/*"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in/src1/1.txt");
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in/src2/1.txt");
            Path target = new Path("/tmp/out");
            Path listingFile = new Path("/tmp/list");
            DistCpOptions options = new DistCpOptions(srcPaths, target);
            CopyListing listing = CopyListing.getCopyListing((Configuration)this.getConf(), (Credentials)CREDENTIALS, (DistCpOptions)options);
            try {
                listing.buildListing(listingFile, options);
                Assert.fail((String)"Duplicates not detected");
            }
            catch (CopyListing.DuplicateFileException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered in test", (Throwable)e);
            Assert.fail((String)("Test failed " + e.getMessage()));
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildListing() {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            Path p1 = new Path("/tmp/in/1");
            Path p2 = new Path("/tmp/in/2");
            Path p3 = new Path("/tmp/in2/2");
            Path target = new Path("/tmp/out/1");
            srcPaths.add(p1.getParent());
            srcPaths.add(p3.getParent());
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in/1");
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in/2");
            TestDistCpUtils.createFile((FileSystem)fs, (String)"/tmp/in2/2");
            fs.mkdirs(target);
            FSDataOutputStream out = fs.create(p1);
            out.write("ABC".getBytes());
            out.close();
            out = fs.create(p2);
            out.write("DEF".getBytes());
            out.close();
            out = fs.create(p3);
            out.write("GHIJ".getBytes());
            out.close();
            Path listingFile = new Path("/tmp/file");
            DistCpOptions options = new DistCpOptions(srcPaths, target);
            options.setSyncFolder(true);
            SimpleCopyListing listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
            try {
                listing.buildListing(listingFile, options);
                Assert.fail((String)"Duplicates not detected");
            }
            catch (CopyListing.DuplicateFileException ignore) {
                // empty catch block
            }
            Assert.assertEquals((long)listing.getBytesToCopy(), (long)10L);
            Assert.assertEquals((long)listing.getNumberOfPaths(), (long)3L);
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
            try {
                listing.buildListing(listingFile, options);
                Assert.fail((String)"Invalid input not detected");
            }
            catch (CopyListing.InvalidInputException ignore) {
                // empty catch block
            }
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)"Test build listing failed");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildListingForSingleFile() {
        block6: {
            FileSystem fs = null;
            String testRootString = "/singleFileListing";
            Path testRoot = new Path(testRootString);
            SequenceFile.Reader reader = null;
            try {
                fs = FileSystem.get((Configuration)this.getConf());
                if (fs.exists(testRoot)) {
                    TestDistCpUtils.delete((FileSystem)fs, (String)testRootString);
                }
                Path sourceFile = new Path(testRoot, "/source/foo/bar/source.txt");
                Path decoyFile = new Path(testRoot, "/target/moo/source.txt");
                Path targetFile = new Path(testRoot, "/target/moo/target.txt");
                TestDistCpUtils.createFile((FileSystem)fs, (String)sourceFile.toString());
                TestDistCpUtils.createFile((FileSystem)fs, (String)decoyFile.toString());
                TestDistCpUtils.createFile((FileSystem)fs, (String)targetFile.toString());
                ArrayList<Path> srcPaths = new ArrayList<Path>();
                srcPaths.add(sourceFile);
                DistCpOptions options = new DistCpOptions(srcPaths, targetFile);
                SimpleCopyListing listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
                Path listFile = new Path(testRoot, "/tmp/fileList.seq");
                listing.buildListing(listFile, options);
                reader = new SequenceFile.Reader(fs, listFile, this.getConf());
                FileStatus fileStatus = new FileStatus();
                Text relativePath = new Text();
                Assert.assertTrue((boolean)reader.next((Writable)relativePath, (Writable)fileStatus));
                Assert.assertTrue((boolean)relativePath.toString().equals(""));
                TestDistCpUtils.delete((FileSystem)fs, (String)testRootString);
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception encountered.");
                LOG.error((Object)"Unexpected exception: ", (Throwable)e);
                break block6;
            }
            finally {
                TestDistCpUtils.delete((FileSystem)fs, (String)testRootString);
                IOUtils.closeStream(reader);
            }
            IOUtils.closeStream((Closeable)reader);
        }
    }
}

