/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.CopyFilter;

public class RegexCopyFilter
extends CopyFilter {
    private static final Log LOG = LogFactory.getLog(RegexCopyFilter.class);
    private File filtersFile;
    private List<Pattern> filters;

    protected RegexCopyFilter(String filtersFilename) {
        this.filtersFile = new File(filtersFilename);
        this.filters = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void initialize() {
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(this.filtersFile);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                Pattern pattern = Pattern.compile(line);
                this.filters.add(pattern);
            }
        }
        catch (FileNotFoundException notFound) {
            LOG.error((Object)("Can't find filters file " + this.filtersFile));
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
        }
        catch (IOException cantRead) {
            LOG.error((Object)("An error occurred while attempting to read from " + this.filtersFile));
            {
                catch (Throwable throwable) {
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
                    throw throwable;
                }
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
    }

    @VisibleForTesting
    protected final void setFilters(List<Pattern> filtersList) {
        this.filters = filtersList;
    }

    public boolean shouldCopy(Path path) {
        for (Pattern filter : this.filters) {
            if (!filter.matcher(path.toString()).matches()) continue;
            return false;
        }
        return true;
    }
}

