/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.junit.Assert;
import org.junit.Test;

public class TestDistCpOptions {
    @Test
    public void testSetIgnoreFailure() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldIgnoreFailures());
        options.setIgnoreFailures(true);
        Assert.assertTrue((boolean)options.shouldIgnoreFailures());
    }

    @Test
    public void testSetOverwrite() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldOverwrite());
        options.setOverwrite(true);
        Assert.assertTrue((boolean)options.shouldOverwrite());
        try {
            options.setSyncFolder(true);
            Assert.fail((String)"Update and overwrite aren't allowed together");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogPath() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)options.getLogPath());
        Path logPath = new Path("hdfs://localhost:8020/logs");
        options.setLogPath(logPath);
        Assert.assertEquals((Object)logPath, (Object)options.getLogPath());
    }

    @Test
    public void testSetBlokcing() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertTrue((boolean)options.shouldBlock());
        options.setBlocking(false);
        Assert.assertFalse((boolean)options.shouldBlock());
    }

    @Test
    public void testSetBandwidth() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((long)100L, (long)options.getMapBandwidth());
        options.setMapBandwidth(11);
        Assert.assertEquals((long)11L, (long)options.getMapBandwidth());
    }

    @Test(expected=AssertionError.class)
    public void testSetNonPositiveBandwidth() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setMapBandwidth(-11);
    }

    @Test(expected=AssertionError.class)
    public void testSetZeroBandwidth() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setMapBandwidth(0);
    }

    @Test
    public void testSetSkipCRC() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldSkipCRC());
        options.setSyncFolder(true);
        options.setSkipCRC(true);
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldSkipCRC());
    }

    @Test
    public void testSetAtomicCommit() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldAtomicCommit());
        options.setAtomicCommit(true);
        Assert.assertTrue((boolean)options.shouldAtomicCommit());
        try {
            options.setSyncFolder(true);
            Assert.fail((String)"Atomic and sync folders were mutually exclusive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetWorkPath() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)options.getAtomicWorkPath());
        options.setAtomicCommit(true);
        Assert.assertNull((Object)options.getAtomicWorkPath());
        Path workPath = new Path("hdfs://localhost:8020/work");
        options.setAtomicWorkPath(workPath);
        Assert.assertEquals((Object)workPath, (Object)options.getAtomicWorkPath());
    }

    @Test
    public void testSetSyncFolders() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldSyncFolder());
        options.setSyncFolder(true);
        Assert.assertTrue((boolean)options.shouldSyncFolder());
    }

    @Test
    public void testSetDeleteMissing() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldDeleteMissing());
        options.setSyncFolder(true);
        options.setDeleteMissing(true);
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setOverwrite(true);
        options.setDeleteMissing(true);
        Assert.assertTrue((boolean)options.shouldOverwrite());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        try {
            options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
            options.setDeleteMissing(true);
            Assert.fail((String)"Delete missing should fail without update or overwrite options");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Delete missing is applicable only with update or overwrite options", (Throwable)e);
        }
        try {
            options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
            options.setSyncFolder(true);
            options.setDeleteMissing(true);
            options.setUseDiff("s1", "s2");
            Assert.assertFalse((String)"-delete should be ignored when -diff is specified", (boolean)options.shouldDeleteMissing());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Got unexpected IllegalArgumentException: " + e.getMessage()));
        }
    }

    @Test
    public void testSetSSLConf() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)options.getSslConfigurationFile());
        options.setSslConfigurationFile("/tmp/ssl-client.xml");
        Assert.assertEquals((Object)"/tmp/ssl-client.xml", (Object)options.getSslConfigurationFile());
    }

    @Test
    public void testSetMaps() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((long)20L, (long)options.getMaxMaps());
        options.setMaxMaps(1);
        Assert.assertEquals((long)1L, (long)options.getMaxMaps());
        options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setMaxMaps(0);
        Assert.assertEquals((long)1L, (long)options.getMaxMaps());
    }

    @Test
    public void testSetNumListtatusThreads() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((long)0L, (long)options.getNumListstatusThreads());
        options.setNumListstatusThreads(12);
        Assert.assertEquals((long)12L, (long)options.getNumListstatusThreads());
        options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setNumListstatusThreads(0);
        Assert.assertEquals((long)0L, (long)options.getNumListstatusThreads());
        options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setNumListstatusThreads(80);
        Assert.assertEquals((long)40L, (long)options.getNumListstatusThreads());
    }

    @Test
    public void testSourceListing() {
        DistCpOptions options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((Object)new Path("hdfs://localhost:8020/source/first"), (Object)options.getSourceFileListing());
    }

    @Test(expected=AssertionError.class)
    public void testMissingTarget() {
        new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), null);
    }

    @Test
    public void testToString() {
        DistCpOptions option = new DistCpOptions(new Path("abc"), new Path("xyz"));
        String val = "DistCpOptions{atomicCommit=false, syncFolder=false, deleteMissing=false, ignoreFailures=false, overwrite=false, append=false, useDiff=false, useRdiff=false, fromSnapshot=null, toSnapshot=null, skipCRC=false, blocking=true, numListstatusThreads=0, maxMaps=20, mapBandwidth=100, sslConfigurationFile='null', copyStrategy='uniformsize', preserveStatus=[], preserveRawXattrs=false, atomicWorkPath=null, logPath=null, sourceFileListing=abc, sourcePaths=null, targetPath=xyz, targetPathExists=true, filtersFile='null', blocksPerChunk=0, copyBufferSize=8192, verboseLog=false}";
        String optionString = option.toString();
        Assert.assertEquals((Object)"DistCpOptions{atomicCommit=false, syncFolder=false, deleteMissing=false, ignoreFailures=false, overwrite=false, append=false, useDiff=false, useRdiff=false, fromSnapshot=null, toSnapshot=null, skipCRC=false, blocking=true, numListstatusThreads=0, maxMaps=20, mapBandwidth=100, sslConfigurationFile='null', copyStrategy='uniformsize', preserveStatus=[], preserveRawXattrs=false, atomicWorkPath=null, logPath=null, sourceFileListing=abc, sourcePaths=null, targetPath=xyz, targetPathExists=true, filtersFile='null', blocksPerChunk=0, copyBufferSize=8192, verboseLog=false}", (Object)optionString);
        Assert.assertNotSame((Object)DistCpOptionSwitch.ATOMIC_COMMIT.toString(), (Object)DistCpOptionSwitch.ATOMIC_COMMIT.name());
    }

    @Test
    public void testCopyStrategy() {
        DistCpOptions options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((Object)"uniformsize", (Object)options.getCopyStrategy());
        options.setCopyStrategy("dynamic");
        Assert.assertEquals((Object)"dynamic", (Object)options.getCopyStrategy());
    }

    @Test
    public void testTargetPath() {
        DistCpOptions options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((Object)new Path("hdfs://localhost:8020/target/"), (Object)options.getTargetPath());
    }

    @Test
    public void testPreserve() {
        DistCpOptions options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        options.preserve(DistCpOptions.FileAttribute.ACL);
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source/")), new Path("hdfs://localhost:8020/target/"));
        options.preserve(DistCpOptions.FileAttribute.BLOCKSIZE);
        options.preserve(DistCpOptions.FileAttribute.REPLICATION);
        options.preserve(DistCpOptions.FileAttribute.PERMISSION);
        options.preserve(DistCpOptions.FileAttribute.USER);
        options.preserve(DistCpOptions.FileAttribute.GROUP);
        options.preserve(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
    }

    @Test
    public void testAppendOption() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source/")), new Path("hdfs://localhost:8020/target/"));
        options.setSyncFolder(true);
        options.setAppend(true);
        Assert.assertTrue((boolean)options.shouldAppend());
        try {
            options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source/")), new Path("hdfs://localhost:8020/target/"));
            options.setAppend(true);
            Assert.fail((String)"Append should fail if update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is valid only with update options", (Throwable)e);
        }
        try {
            options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source/")), new Path("hdfs://localhost:8020/target/"));
            options.setSyncFolder(true);
            options.setAppend(true);
            options.setSkipCRC(true);
            Assert.fail((String)"Append should fail if skipCrc option is specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is disallowed when skipping CRC", (Throwable)e);
        }
    }

    @Test
    public void testDiffOption() {
        DistCpOptions options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        options.setSyncFolder(true);
        options.setUseDiff("s1", "s2");
        Assert.assertTrue((boolean)options.shouldUseDiff());
        Assert.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assert.assertEquals((Object)"s2", (Object)options.getToSnapshot());
        options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        options.setSyncFolder(true);
        options.setUseDiff("s1", ".");
        Assert.assertTrue((boolean)options.shouldUseDiff());
        Assert.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assert.assertEquals((Object)".", (Object)options.getToSnapshot());
        try {
            options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
            options.setUseDiff("s1", "s2");
            Assert.fail((String)"-diff should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
            options.setSyncFolder(true);
            options.setUseDiff("s1", "s2");
            options.setDeleteMissing(true);
            Assert.assertFalse((String)"-delete should be ignored when -diff is specified", (boolean)options.shouldDeleteMissing());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Got unexpected IllegalArgumentException: " + e.getMessage()));
        }
        try {
            options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
            options.setUseDiff("s1", "s2");
            options.setDeleteMissing(true);
            Assert.fail((String)"-diff should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
            options.setDeleteMissing(true);
            options.setUseDiff("s1", "s2");
            Assert.fail((String)"-delete should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Delete missing is applicable only with update or overwrite options", (Throwable)e);
        }
    }

    @Test
    public void testExclusionsOption() {
        DistCpOptions options = new DistCpOptions(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)options.getFiltersFile());
        options.setFiltersFile("/tmp/filters.txt");
        Assert.assertEquals((Object)"/tmp/filters.txt", (Object)options.getFiltersFile());
    }

    @Test
    public void testVerboseLog() {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)options.shouldVerboseLog());
        try {
            options.setVerboseLog(true);
            Assert.fail((String)"-v should fail if -log option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-v is valid only with -log option", (Throwable)e);
        }
        Path logPath = new Path("hdfs://localhost:8020/logs");
        options.setLogPath(logPath);
        options.setVerboseLog(true);
        Assert.assertTrue((boolean)options.shouldVerboseLog());
    }

    @Test
    public void testAppendToConf() {
        int expectedBlocksPerChunk = 999;
        String expectedValForEmptyConfigKey = "VALUE_OF_EMPTY_CONFIG_KEY";
        DistCpOptions options = new DistCpOptions(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        options.setBlocksPerChunk(999);
        Configuration config = new Configuration();
        config.set("", "VALUE_OF_EMPTY_CONFIG_KEY");
        options.appendToConf(config);
        Assert.assertEquals((long)999L, (long)config.getInt(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getConfigLabel(), 0));
        Assert.assertEquals((String)"Some DistCpOptionSwitch's config label is empty! Pls ensure the config label is provided when apply to config, otherwise it may not be fetched properly", (Object)"VALUE_OF_EMPTY_CONFIG_KEY", (Object)config.get(""));
    }
}

