/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.mapred.RetriableDirectoryCreateCommand;
import org.apache.hadoop.tools.mapred.RetriableFileCopyCommand;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CopyMapper
extends Mapper<Text, FileStatus, Text, Text> {
    private static Log LOG = LogFactory.getLog(CopyMapper.class);
    private Configuration conf;
    private boolean syncFolders = false;
    private boolean ignoreFailures = false;
    private boolean skipCrc = false;
    private boolean overWrite = false;
    private EnumSet<DistCpOptions.FileAttribute> preserve = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
    private FileSystem targetFS = null;
    private Path targetWorkPath = null;

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.syncFolders = this.conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false);
        this.ignoreFailures = this.conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false);
        this.skipCrc = this.conf.getBoolean(DistCpOptionSwitch.SKIP_CRC.getConfigLabel(), false);
        this.overWrite = this.conf.getBoolean(DistCpOptionSwitch.OVERWRITE.getConfigLabel(), false);
        this.preserve = DistCpUtils.unpackAttributes((String)this.conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()));
        this.targetWorkPath = new Path(this.conf.get("distcp.target.work.path"));
        Path targetFinalPath = new Path(this.conf.get("distcp.target.final.path"));
        this.targetFS = targetFinalPath.getFileSystem(this.conf);
        if (this.targetFS.exists(targetFinalPath) && this.targetFS.isFile(targetFinalPath)) {
            this.overWrite = true;
        }
        if (this.conf.get("distcp.keystore.resource") != null) {
            this.initializeSSLConf(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSSLConf(Mapper.Context context) throws IOException {
        LOG.info((Object)"Initializing SSL configuration");
        String workDir = this.conf.get("mapreduce.job.local.dir") + "/work";
        Object[] cacheFiles = context.getLocalCacheFiles();
        Configuration sslConfig = new Configuration(false);
        String sslConfFileName = this.conf.get("distcp.keystore.resource");
        Path sslClient = this.findCacheFile((Path[])cacheFiles, sslConfFileName);
        if (sslClient == null) {
            LOG.warn((Object)("SSL Client config file not found. Was looking for " + sslConfFileName + " in " + Arrays.toString(cacheFiles)));
            return;
        }
        sslConfig.addResource(sslClient);
        String trustStoreFile = this.conf.get("ssl.client.truststore.location");
        Path trustStorePath = this.findCacheFile((Path[])cacheFiles, trustStoreFile);
        sslConfig.set("ssl.client.truststore.location", trustStorePath.toString());
        String keyStoreFile = this.conf.get("ssl.client.keystore.location");
        Path keyStorePath = this.findCacheFile((Path[])cacheFiles, keyStoreFile);
        sslConfig.set("ssl.client.keystore.location", keyStorePath.toString());
        try {
            FileOutputStream out = new FileOutputStream(workDir + "/" + sslConfFileName);
            try {
                sslConfig.writeXml((OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
            this.conf.set("dfs.https.client.keystore.resource", sslConfFileName);
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to write out the ssl configuration. Will fall back to default ssl-client.xml in class path, if there is one", (Throwable)e);
        }
    }

    private Path findCacheFile(Path[] cacheFiles, String fileName) {
        if (cacheFiles != null && cacheFiles.length > 0) {
            for (Path file : cacheFiles) {
                if (!file.getName().equals(fileName)) continue;
                return file;
            }
        }
        return null;
    }

    public void map(Text relPath, FileStatus sourceFileStatus, Mapper.Context context) throws IOException, InterruptedException {
        Path sourcePath = sourceFileStatus.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DistCpMapper::map(): Received " + sourcePath + ", " + relPath));
        }
        Path target = new Path(this.targetWorkPath.makeQualified(this.targetFS.getUri(), this.targetFS.getWorkingDirectory()) + relPath.toString());
        EnumSet fileAttributes = CopyMapper.getFileAttributeSettings((Mapper.Context)context);
        String description = "Copying " + sourcePath + " to " + target;
        context.setStatus(description);
        LOG.info((Object)description);
        try {
            FileStatus targetStatus;
            FileStatus sourceCurrStatus;
            FileSystem sourceFS;
            block11: {
                try {
                    sourceFS = sourcePath.getFileSystem(this.conf);
                    sourceCurrStatus = sourceFS.getFileStatus(sourcePath);
                }
                catch (FileNotFoundException e) {
                    throw new IOException((Throwable)new RetriableFileCopyCommand.CopyReadException((Throwable)e));
                }
                targetStatus = null;
                try {
                    targetStatus = this.targetFS.getFileStatus(target);
                }
                catch (FileNotFoundException ignore) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug((Object)("Path could not be found: " + target), (Throwable)ignore);
                }
            }
            if (targetStatus != null && targetStatus.isDirectory() != sourceCurrStatus.isDirectory()) {
                throw new IOException("Can't replace " + target + ". Target is " + this.getFileType(targetStatus) + ", Source is " + this.getFileType(sourceCurrStatus));
            }
            if (sourceCurrStatus.isDirectory()) {
                this.createTargetDirsWithRetry(description, target, context);
                return;
            }
            if (this.skipFile(sourceFS, sourceCurrStatus, target)) {
                LOG.info((Object)("Skipping copy of " + sourceCurrStatus.getPath() + " to " + target));
                CopyMapper.updateSkipCounters((Mapper.Context)context, (FileStatus)sourceCurrStatus);
                context.write(null, (Object)new Text("SKIP: " + sourceCurrStatus.getPath()));
            } else {
                this.copyFileWithRetry(description, sourceCurrStatus, target, context, fileAttributes);
            }
            DistCpUtils.preserve((FileSystem)target.getFileSystem(this.conf), (Path)target, (FileStatus)sourceCurrStatus, (EnumSet)fileAttributes);
        }
        catch (IOException exception) {
            this.handleFailures(exception, sourceFileStatus, target, context);
        }
    }

    private String getFileType(FileStatus fileStatus) {
        return fileStatus == null ? "N/A" : (fileStatus.isDirectory() ? "dir" : "file");
    }

    private static EnumSet<DistCpOptions.FileAttribute> getFileAttributeSettings(Mapper.Context context) {
        String attributeString = context.getConfiguration().get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel());
        return DistCpUtils.unpackAttributes((String)attributeString);
    }

    private void copyFileWithRetry(String description, FileStatus sourceFileStatus, Path target, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        long bytesCopied;
        try {
            bytesCopied = (Long)new RetriableFileCopyCommand(this.skipCrc, description).execute(new Object[]{sourceFileStatus, target, context, fileAttributes});
        }
        catch (Exception e) {
            context.setStatus("Copy Failure: " + sourceFileStatus.getPath());
            throw new IOException("File copy failed: " + sourceFileStatus.getPath() + " --> " + target, e);
        }
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESEXPECTED, (long)sourceFileStatus.getLen());
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESCOPIED, (long)bytesCopied);
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.COPY, (long)1L);
    }

    private void createTargetDirsWithRetry(String description, Path target, Mapper.Context context) throws IOException {
        try {
            new RetriableDirectoryCreateCommand(description).execute(new Object[]{target, context});
        }
        catch (Exception e) {
            throw new IOException("mkdir failed for " + target, e);
        }
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.COPY, (long)1L);
    }

    private static void updateSkipCounters(Mapper.Context context, FileStatus sourceFile) {
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.SKIP, (long)1L);
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESSKIPPED, (long)sourceFile.getLen());
    }

    private void handleFailures(IOException exception, FileStatus sourceFileStatus, Path target, Mapper.Context context) throws IOException, InterruptedException {
        LOG.error((Object)("Failure in copying " + sourceFileStatus.getPath() + " to " + target), (Throwable)exception);
        if (!this.ignoreFailures || !(exception.getCause() instanceof RetriableFileCopyCommand.CopyReadException)) {
            throw exception;
        }
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.FAIL, (long)1L);
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESFAILED, (long)sourceFileStatus.getLen());
        context.write(null, (Object)new Text("FAIL: " + sourceFileStatus.getPath() + " - " + StringUtils.stringifyException((Throwable)exception)));
    }

    private static void incrementCounter(Mapper.Context context, Counter counter, long value) {
        context.getCounter((Enum)counter).increment(value);
    }

    private boolean skipFile(FileSystem sourceFS, FileStatus source, Path target) throws IOException {
        return this.targetFS.exists(target) && !this.overWrite && !this.mustUpdate(sourceFS, source, target);
    }

    private boolean mustUpdate(FileSystem sourceFS, FileStatus source, Path target) throws IOException {
        FileStatus targetFileStatus = this.targetFS.getFileStatus(target);
        return this.syncFolders && (targetFileStatus.getLen() != source.getLen() || !this.skipCrc && !DistCpUtils.checksumsAreEqual((FileSystem)sourceFS, (Path)source.getPath(), null, (FileSystem)this.targetFS, (Path)target) || source.getBlockSize() != targetFileStatus.getBlockSize() && this.preserve.contains(DistCpOptions.FileAttribute.BLOCKSIZE));
    }
}

