/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.DistCpSync;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.StubContext;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDistCpSync {
    private MiniDFSCluster cluster;
    private final Configuration conf = new HdfsConfiguration();
    private DistributedFileSystem dfs;
    private DistCpOptions options;
    private final Path source = new Path("/source");
    private final Path target = new Path("/target");
    private final long BLOCK_SIZE = 1024L;
    private final short DATA_NUM = 1;

    @Before
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.mkdirs(this.source);
        this.dfs.mkdirs(this.target);
        this.options = new DistCpOptions(Arrays.asList(this.source), this.target);
        this.options.setSyncFolder(true);
        this.options.setDeleteMissing(true);
        this.options.setUseDiff(true, "s1", "s2");
        this.options.appendToConf(this.conf);
        this.conf.set("distcp.target.work.path", this.target.toString());
        this.conf.set("distcp.target.final.path", this.target.toString());
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.dfs});
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFallback() throws Exception {
        Assert.assertFalse((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        this.options.setSourcePaths(Arrays.asList(this.source));
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        Assert.assertFalse((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        this.options.setSourcePaths(Arrays.asList(this.source));
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.source, "s2");
        this.dfs.createSnapshot(this.target, "s1");
        Assert.assertTrue((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        this.options.setSourcePaths(Arrays.asList(this.source));
        Path subTarget = new Path(this.target, "sub");
        this.dfs.mkdirs(subTarget);
        Assert.assertFalse((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        this.options.setSourcePaths(Arrays.asList(this.source));
        this.dfs.delete(subTarget, true);
        Assert.assertTrue((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
    }

    private void initData(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(foo, "d1");
        Path f1 = new Path(foo, "f1");
        Path d2 = new Path(bar, "d2");
        Path f2 = new Path(bar, "f2");
        Path f3 = new Path(d1, "f3");
        Path f4 = new Path(d2, "f4");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f4, (long)1024L, (short)1, (long)0L);
    }

    private void changeData(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(foo, "d1");
        Path f2 = new Path(bar, "f2");
        Path bar_d1 = new Path(bar, "d1");
        this.dfs.rename(d1, bar_d1);
        Path f3 = new Path(bar_d1, "f3");
        this.dfs.delete(f3, true);
        Path newfoo = new Path(bar_d1, "foo");
        this.dfs.rename(foo, newfoo);
        Path f1 = new Path(newfoo, "f1");
        this.dfs.delete(f1, true);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)2048L, (short)1, (long)0L);
        DFSTestUtil.appendFile((FileSystem)this.dfs, (Path)f2, (int)1024);
        this.dfs.rename(bar, new Path(dir, "foo"));
    }

    @Test
    public void testSync() throws Exception {
        this.initData(this.source);
        this.initData(this.target);
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.target, "s1");
        this.changeData(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        Path toDelete = new Path(this.source, "foo/d1/foo/f1");
        this.dfs.delete(toDelete, true);
        Path newdir = new Path(this.source, "foo/d1/foo/newdir");
        this.dfs.mkdirs(newdir);
        Assert.assertTrue((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        GlobbedCopyListing listing = new GlobbedCopyListing(this.conf, new Credentials());
        listing.buildListing(listingPath, this.options);
        Map copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context context = stubContext.getContext();
        context.getConfiguration().setBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), true);
        copyMapper.setup(context);
        for (Map.Entry entry : copyListing.entrySet()) {
            copyMapper.map((Text)entry.getKey(), (CopyListingFileStatus)entry.getValue(), context);
        }
        Assert.assertEquals((long)3072L, (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.BYTESCOPIED).getValue());
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    private Map<Text, CopyListingFileStatus> getListing(Path listingPath) throws Exception {
        SequenceFile.Reader reader = new SequenceFile.Reader(this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)listingPath)});
        Text key = new Text();
        CopyListingFileStatus value = new CopyListingFileStatus();
        HashMap<Text, CopyListingFileStatus> values = new HashMap<Text, CopyListingFileStatus>();
        while (reader.next((Writable)key, (Writable)value)) {
            values.put(key, value);
            key = new Text();
            value = new CopyListingFileStatus();
        }
        return values;
    }

    private void verifyCopy(FileStatus s, FileStatus t, boolean compareName) throws Exception {
        Assert.assertEquals((Object)s.isDirectory(), (Object)t.isDirectory());
        if (compareName) {
            Assert.assertEquals((Object)s.getPath().getName(), (Object)t.getPath().getName());
        }
        if (!s.isDirectory()) {
            byte[] sbytes = DFSTestUtil.readFileBuffer((FileSystem)this.dfs, (Path)s.getPath());
            byte[] tbytes = DFSTestUtil.readFileBuffer((FileSystem)this.dfs, (Path)t.getPath());
            Assert.assertArrayEquals((byte[])sbytes, (byte[])tbytes);
        } else {
            FileStatus[] slist = this.dfs.listStatus(s.getPath());
            FileStatus[] tlist = this.dfs.listStatus(t.getPath());
            Assert.assertEquals((long)slist.length, (long)tlist.length);
            for (int i = 0; i < slist.length; ++i) {
                this.verifyCopy(slist[i], tlist[i], true);
            }
        }
    }

    @Test
    public void testSyncWithCurrent() throws Exception {
        this.options.setUseDiff(true, "s1", ".");
        this.initData(this.source);
        this.initData(this.target);
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.target, "s1");
        this.changeData(this.source);
        Assert.assertTrue((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        Assert.assertEquals((Object)this.source, this.options.getSourcePaths().get(0));
    }

    private void initData2(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "f1");
        Path f2 = new Path(foo, "f2");
        Path f3 = new Path(bar, "f3");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)1L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)1024L, (short)1, (long)2L);
    }

    private void changeData2(Path dir) throws Exception {
        Path tmpFoo = new Path(dir, "tmpFoo");
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        this.dfs.rename(test, tmpFoo);
        this.dfs.rename(foo, test);
        this.dfs.rename(bar, foo);
        this.dfs.rename(tmpFoo, bar);
    }

    @Test
    public void testSync2() throws Exception {
        this.initData2(this.source);
        this.initData2(this.target);
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.target, "s1");
        this.changeData2(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        Assert.assertTrue((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        this.verifyCopy(this.dfs.getFileStatus(this.source), this.dfs.getFileStatus(this.target), false);
    }

    private void initData3(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "file");
        Path f2 = new Path(foo, "file");
        Path f3 = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)2048L, (short)1, (long)1L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)3072L, (short)1, (long)2L);
    }

    private void changeData3(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "file");
        Path f2 = new Path(foo, "file");
        Path f3 = new Path(bar, "file");
        Path newf1 = new Path(test, "newfile");
        Path newf2 = new Path(foo, "newfile");
        Path newf3 = new Path(bar, "newfile");
        this.dfs.rename(f1, newf1);
        this.dfs.rename(f2, newf2);
        this.dfs.rename(f3, newf3);
    }

    @Test
    public void testSync3() throws Exception {
        this.initData3(this.source);
        this.initData3(this.target);
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.target, "s1");
        this.changeData3(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        Assert.assertTrue((boolean)DistCpSync.sync((DistCpOptions)this.options, (Configuration)this.conf));
        this.verifyCopy(this.dfs.getFileStatus(this.source), this.dfs.getFileStatus(this.target), false);
    }
}

