/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCpViewFs {
    private static final Log LOG = LogFactory.getLog(TestDistCpViewFs.class);
    private static FileSystem fs;
    private static Path listFile;
    private static Path target;
    private static String root;

    private static Configuration getConf() throws URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("mapred.job.tracker", "local");
        conf.set("fs.default.name", "file:///");
        return conf;
    }

    @BeforeClass
    public static void setup() throws URISyntaxException {
        try {
            Path fswd = FileSystem.get((Configuration)TestDistCpViewFs.getConf()).getWorkingDirectory();
            Configuration vConf = ViewFileSystemTestSetup.createConfig((boolean)false);
            ConfigUtil.addLink((Configuration)vConf, (String)"/usr", (URI)new URI(fswd.toString()));
            fs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)vConf);
            fs.setWorkingDirectory(new Path("/usr"));
            listFile = new Path("target/tmp/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            target = new Path("target/tmp/target").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            root = new Path("target/tmp").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
        }
    }

    @Test
    public void testSingleFileMissingTarget() {
        this.caseSingleFileMissingTarget(false);
        this.caseSingleFileMissingTarget(true);
    }

    private void caseSingleFileMissingTarget(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singlefile1/file1"});
            this.createFiles(new String[]{"singlefile1/file1"});
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 1, new String[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleFileTargetFile() {
        this.caseSingleFileTargetFile(false);
        this.caseSingleFileTargetFile(true);
    }

    private void caseSingleFileTargetFile(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singlefile1/file1"});
            this.createFiles(new String[]{"singlefile1/file1", target.toString()});
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 1, new String[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleFileTargetDir() {
        this.caseSingleFileTargetDir(false);
        this.caseSingleFileTargetDir(true);
    }

    private void caseSingleFileTargetDir(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singlefile2/file2"});
            this.createFiles(new String[]{"singlefile2/file2"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, true, sync);
            this.checkResult(target, 1, new String[]{"file2"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleDirTargetMissing() {
        this.caseSingleDirTargetMissing(false);
        this.caseSingleDirTargetMissing(true);
    }

    private void caseSingleDirTargetMissing(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singledir"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 1, new String[]{"dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"singledir"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, true, false);
            this.checkResult(target, 1, new String[]{"singledir/dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testUpdateSingleDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"Usingledir"});
            this.mkdirs(new String[]{root + "/Usingledir/Udir1"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, true, true);
            this.checkResult(target, 1, new String[]{"Udir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testMultiFileTargetPresent() {
        this.caseMultiFileTargetPresent(false);
        this.caseMultiFileTargetPresent(true);
    }

    private void caseMultiFileTargetPresent(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, true, sync);
            this.checkResult(target, 3, new String[]{"file3", "file4", "file5"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testMultiFileTargetMissing() {
        this.caseMultiFileTargetMissing(false);
        this.caseMultiFileTargetMissing(true);
    }

    private void caseMultiFileTargetMissing(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 3, new String[]{"file3", "file4", "file5"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testMultiDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"multifile", "singledir"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{target.toString(), root + "/singledir/dir1"});
            this.runTest(listFile, target, true, false);
            this.checkResult(target, 2, new String[]{"multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testUpdateMultiDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"Umultifile", "Usingledir"});
            this.createFiles(new String[]{"Umultifile/Ufile3", "Umultifile/Ufile4", "Umultifile/Ufile5"});
            this.mkdirs(new String[]{target.toString(), root + "/Usingledir/Udir1"});
            this.runTest(listFile, target, true, true);
            this.checkResult(target, 4, new String[]{"Ufile3", "Ufile4", "Ufile5", "Udir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testMultiDirTargetMissing() {
        try {
            this.addEntries(listFile, new String[]{"multifile", "singledir"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.runTest(listFile, target, false, false);
            this.checkResult(target, 2, new String[]{"multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testUpdateMultiDirTargetMissing() {
        try {
            this.addEntries(listFile, new String[]{"multifile", "singledir"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.runTest(listFile, target, false, true);
            this.checkResult(target, 4, new String[]{"file3", "file4", "file5", "dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testGlobTargetMissingSingleLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir/dir2/file6"});
            this.runTest(listFile, target, false, false);
            this.checkResult(target, 2, new String[]{"multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir2/file6"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    @Test
    public void testUpdateGlobTargetMissingSingleLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir/dir2/file6"});
            this.runTest(listFile, target, false, true);
            this.checkResult(target, 4, new String[]{"file3", "file4", "file5", "dir2/file6"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    @Test
    public void testGlobTargetMissingMultiLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*/*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9"});
            this.runTest(listFile, target, false, false);
            this.checkResult(target, 4, new String[]{"file3", "file4", "file5", "dir3/file7", "dir3/file8", "dir3/file9"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    @Test
    public void testUpdateGlobTargetMissingMultiLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*/*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9"});
            this.runTest(listFile, target, false, true);
            this.checkResult(target, 6, new String[]{"file3", "file4", "file5", "file7", "file8", "file9"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntries(Path listFile, String ... entries) throws IOException {
        try (FSDataOutputStream out = fs.create(listFile);){
            for (String entry : entries) {
                out.write((root + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(String ... entries) throws IOException {
        for (String entry : entries) {
            String e = new Path(entry).isAbsolute() ? entry : root + "/" + entry;
            try (FSDataOutputStream out = fs.create(new Path(e));){
                out.write(e.getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    private void mkdirs(String ... entries) throws IOException {
        for (String entry : entries) {
            fs.mkdirs(new Path(entry));
        }
    }

    private void runTest(Path listFile, Path target, boolean targetExists, boolean sync) throws IOException {
        DistCpOptions options = new DistCpOptions(listFile, target);
        options.setSyncFolder(sync);
        options.setTargetPathExists(targetExists);
        try {
            new DistCp(TestDistCpViewFs.getConf(), options).execute();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void checkResult(Path target, int count, String ... relPaths) throws IOException {
        Assert.assertEquals((long)count, (long)fs.listStatus(target).length);
        if (relPaths == null || relPaths.length == 0) {
            Assert.assertTrue((String)target.toString(), (boolean)fs.exists(target));
            return;
        }
        for (String relPath : relPaths) {
            Assert.assertTrue((String)new Path(target, relPath).toString(), (boolean)fs.exists(new Path(target, relPath)));
        }
    }
}

