/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import org.apache.commons.cli.Option;
import org.apache.hadoop.conf.Configuration;

public enum DistCpOptionSwitch {
    IGNORE_FAILURES("distcp.ignore.failures", new Option("i", false, "Ignore failures during copy")),
    PRESERVE_STATUS("distcp.preserve.status", new Option("p", true, "preserve status (rbugpcaxt)(replication, block-size, user, group, permission, checksum-type, ACL, XATTR, timestamps). If -p is specified with no <arg>, then preserves replication, block size, user, group, permission, checksum type and timestamps. raw.* xattrs are preserved when both the source and destination paths are in the /.reserved/raw hierarchy (HDFS only). raw.* xattrpreservation is independent of the -p flag. Refer to the DistCp documentation for more details.")),
    SYNC_FOLDERS("distcp.sync.folders", new Option("update", false, "Update target, copying only missingfiles or directories")),
    DELETE_MISSING("distcp.delete.missing.source", new Option("delete", false, "Delete from target, files missing in source. Delete is applicable only with update or overwrite options")),
    SSL_CONF("distcp.keystore.resource", new Option("mapredSslConf", true, "Configuration for ssl config file, to use with hftps://. Must be in the classpath.")),
    NUM_LISTSTATUS_THREADS("distcp.liststatus.threads", new Option("numListstatusThreads", true, "Number of threads to use for building file listing (max 40).")),
    MAX_MAPS("distcp.max.maps", new Option("m", true, "Max number of concurrent maps to use for copy")),
    SOURCE_FILE_LISTING("distcp.source.listing", new Option("f", true, "List of files that need to be copied")),
    ATOMIC_COMMIT("distcp.atomic.copy", new Option("atomic", false, "Commit all changes or none")),
    WORK_PATH("distcp.work.path", new Option("tmp", true, "Intermediate work path to be used for atomic commit")),
    LOG_PATH("distcp.log.path", new Option("log", true, "Folder on DFS where distcp execution logs are saved")),
    VERBOSE_LOG("distcp.verbose.log", new Option("v", false, "Log additional info (path, size) in the SKIP/COPY log")),
    COPY_STRATEGY("distcp.copy.strategy", new Option("strategy", true, "Copy strategy to use. Default is dividing work based on file sizes")),
    SKIP_CRC("distcp.skip.crc", new Option("skipcrccheck", false, "Whether to skip CRC checks between source and target paths.")),
    OVERWRITE("distcp.copy.overwrite", new Option("overwrite", false, "Choose to overwrite target files unconditionally, even if they exist.")),
    APPEND("distcp.copy.append", new Option("append", false, "Reuse existing data in target files and append new data to them if possible")),
    DIFF("distcp.copy.diff", new Option("diff", false, "Use snapshot diff report to identify the difference between source and target"), 2),
    RDIFF("distcp.copy.rdiff", new Option("rdiff", false, "Use target snapshot diff report to identify changes made on target"), 2),
    BLOCKING("", new Option("async", false, "Should distcp execution be blocking")),
    FILE_LIMIT("", new Option("filelimit", true, "(Deprecated!) Limit number of files copied to <= n")),
    SIZE_LIMIT("", new Option("sizelimit", true, "(Deprecated!) Limit number of files copied to <= n bytes")),
    BLOCKS_PER_CHUNK("", new Option("blocksperchunk", true, "If set to a positive value, fileswith more blocks than this value will be split into chunks of <blocksperchunk> blocks to be transferred in parallel, and reassembled on the destination. By default, <blocksperchunk> is 0 and the files will be transmitted in their entirety without splitting. This switch is only applicable when the source file system implements getBlockLocations method and the target file system implements concat method")),
    COPY_BUFFER_SIZE("distcp.copy.buffer.size", new Option("copybuffersize", true, "Size of the copy buffer to use. By default <copybuffersize> is 8192B.")),
    BANDWIDTH("distcp.map.bandwidth.mb", new Option("bandwidth", true, "Specify bandwidth per map in MB")),
    FILTERS("distcp.filters.file", new Option("filters", true, "The path to a file containing a list of strings for paths to be excluded from the copy."));

    public static final String PRESERVE_STATUS_DEFAULT = "-prbugpct";
    private final String confLabel;
    private final Option option;

    private DistCpOptionSwitch(String confLabel, Option option) {
        this.confLabel = confLabel;
        this.option = option;
    }

    private DistCpOptionSwitch(String confLabel, Option option, int argNum) {
        this(confLabel, option);
        this.option.setArgs(argNum);
    }

    public String getConfigLabel() {
        return this.confLabel;
    }

    public Option getOption() {
        return this.option;
    }

    public String getSwitch() {
        return this.option.getOpt();
    }

    public String toString() {
        return super.name() + " {" + "confLabel='" + this.confLabel + '\'' + ", option=" + this.option + '}';
    }

    public static void addToConf(Configuration conf, DistCpOptionSwitch option, String value) {
        conf.set(option.getConfigLabel(), value);
    }

    public static void addToConf(Configuration conf, DistCpOptionSwitch option) {
        conf.set(option.getConfigLabel(), "true");
    }
}

