/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.DistCpSync;
import org.apache.hadoop.tools.OptionsParser;
import org.apache.hadoop.tools.SimpleCopyListing;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.mapred.CopyOutputFormat;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DistCp
extends Configured
implements Tool {
    static final int SHUTDOWN_HOOK_PRIORITY = 30;
    static final Log LOG = LogFactory.getLog(DistCp.class);
    @VisibleForTesting
    DistCpContext context;
    private Path metaFolder;
    private static final String PREFIX = "_distcp";
    private static final String WIP_PREFIX = "._WIP_";
    private static final String DISTCP_DEFAULT_XML = "distcp-default.xml";
    private static final String DISTCP_SITE_XML = "distcp-site.xml";
    static final Random rand = new Random();
    private boolean submitted;
    private FileSystem jobFS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareFileListing(Job job) throws Exception {
        if (this.context.shouldUseSnapshotDiff()) {
            DistCpSync distCpSync = new DistCpSync(this.context, this.getConf());
            if (!distCpSync.sync()) throw new Exception("DistCp sync failed, input options: " + this.context);
            this.createInputFileListingWithDiff(job, distCpSync);
            return;
        } else {
            this.createInputFileListing(job);
        }
    }

    public DistCp(Configuration configuration, DistCpOptions inputOptions) throws Exception {
        Configuration config = new Configuration(configuration);
        config.addResource(DISTCP_DEFAULT_XML);
        config.addResource(DISTCP_SITE_XML);
        this.setConf(config);
        if (inputOptions != null) {
            this.context = new DistCpContext(inputOptions);
        }
        this.metaFolder = this.createMetaFolderPath();
    }

    @VisibleForTesting
    DistCp() {
    }

    public int run(String[] argv) {
        if (argv.length < 1) {
            OptionsParser.usage();
            return -1;
        }
        try {
            this.context = new DistCpContext(OptionsParser.parse(argv));
            this.checkSplitLargeFile();
            this.setTargetPathExists();
            LOG.info((Object)("Input Options: " + this.context));
        }
        catch (Throwable e) {
            LOG.error((Object)"Invalid arguments: ", e);
            System.err.println("Invalid arguments: " + e.getMessage());
            OptionsParser.usage();
            return -1;
        }
        try {
            this.execute();
        }
        catch (CopyListing.InvalidInputException e) {
            LOG.error((Object)"Invalid input: ", (Throwable)e);
            return -1;
        }
        catch (CopyListing.DuplicateFileException e) {
            LOG.error((Object)"Duplicate files in input path: ", (Throwable)e);
            return -2;
        }
        catch (CopyListing.AclsNotSupportedException e) {
            LOG.error((Object)"ACLs not supported on at least one file system: ", (Throwable)e);
            return -3;
        }
        catch (CopyListing.XAttrsNotSupportedException e) {
            LOG.error((Object)"XAttrs not supported on at least one file system: ", (Throwable)e);
            return -4;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            return -999;
        }
        return 0;
    }

    public Job execute() throws Exception {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"The DistCpContext should have been created before running DistCp!");
        Job job = this.createAndSubmitJob();
        if (this.context.shouldBlock()) {
            this.waitForJobCompletion(job);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job createAndSubmitJob() throws Exception {
        assert (this.context != null);
        assert (this.getConf() != null);
        Job job = null;
        try {
            DistCp distCp = this;
            synchronized (distCp) {
                this.metaFolder = this.createMetaFolderPath();
                this.jobFS = this.metaFolder.getFileSystem(this.getConf());
                job = this.createJob();
            }
            this.prepareFileListing(job);
            job.submit();
            this.submitted = true;
        }
        finally {
            if (!this.submitted) {
                this.cleanup();
            }
        }
        String jobID = job.getJobID().toString();
        job.getConfiguration().set("distcp.job.id", jobID);
        LOG.info((Object)("DistCp job-id: " + jobID));
        return job;
    }

    public void waitForJobCompletion(Job job) throws Exception {
        assert (job != null);
        if (!job.waitForCompletion(true)) {
            throw new IOException("DistCp failure: Job " + job.getJobID() + " has failed: " + job.getStatus().getFailureInfo());
        }
    }

    private void setTargetPathExists() throws IOException {
        Path target = this.context.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        boolean targetExists = targetFS.exists(target);
        this.context.setTargetPathExists(targetExists);
        this.getConf().setBoolean("distcp.target.path.exists", targetExists);
    }

    private void checkSplitLargeFile() throws IOException {
        if (!this.context.splitLargeFile()) {
            return;
        }
        Path target = this.context.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        try {
            Path[] src = null;
            Path tgt = null;
            targetFS.concat(tgt, src);
        }
        catch (UnsupportedOperationException use) {
            throw new UnsupportedOperationException(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch() + " is not supported since the target file system doesn't support concat.", use);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.info((Object)("Set distcp.simplelisting.randomize.files to false since " + DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch() + " is passed."));
        this.getConf().setBoolean("distcp.simplelisting.randomize.files", false);
    }

    private Job createJob() throws IOException {
        String jobName = "distcp";
        String userChosenName = this.getConf().get("mapreduce.job.name");
        if (userChosenName != null) {
            jobName = jobName + ": " + userChosenName;
        }
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(jobName);
        job.setInputFormatClass(DistCpUtils.getStrategy(this.getConf(), this.context));
        job.setJarByClass(CopyMapper.class);
        this.configureOutputFormat(job);
        job.setMapperClass(CopyMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(CopyOutputFormat.class);
        job.getConfiguration().set("mapreduce.map.speculative", "false");
        job.getConfiguration().set("mapreduce.job.maps", String.valueOf(this.context.getMaxMaps()));
        this.context.appendToConf(job.getConfiguration());
        return job;
    }

    private void configureOutputFormat(Job job) throws IOException {
        Configuration configuration = job.getConfiguration();
        Path targetPath = this.context.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(configuration);
        targetPath = targetPath.makeQualified(targetFS.getUri(), targetFS.getWorkingDirectory());
        if (this.context.shouldPreserve(DistCpOptions.FileAttribute.ACL)) {
            DistCpUtils.checkFileSystemAclSupport(targetFS);
        }
        if (this.context.shouldPreserve(DistCpOptions.FileAttribute.XATTR)) {
            DistCpUtils.checkFileSystemXAttrSupport(targetFS);
        }
        if (this.context.shouldAtomicCommit()) {
            FileSystem workFS;
            Path workDir = this.context.getAtomicWorkPath();
            if (workDir == null) {
                workDir = targetPath.getParent();
            }
            if (!FileUtil.compareFs((FileSystem)targetFS, (FileSystem)(workFS = (workDir = new Path(workDir, WIP_PREFIX + targetPath.getName() + rand.nextInt())).getFileSystem(configuration)))) {
                throw new IllegalArgumentException("Work path " + workDir + " and target path " + targetPath + " are in different file system");
            }
            CopyOutputFormat.setWorkingDirectory(job, workDir);
        } else {
            CopyOutputFormat.setWorkingDirectory(job, targetPath);
        }
        CopyOutputFormat.setCommitDirectory(job, targetPath);
        Path logPath = this.context.getLogPath();
        if (logPath == null) {
            logPath = new Path(this.metaFolder, "_logs");
        } else {
            LOG.info((Object)("DistCp job log path: " + logPath));
        }
        CopyOutputFormat.setOutputPath((Job)job, (Path)logPath);
    }

    protected Path createInputFileListing(Job job) throws IOException {
        Path fileListingPath = this.getFileListingPath();
        CopyListing copyListing = CopyListing.getCopyListing(job.getConfiguration(), job.getCredentials(), this.context);
        copyListing.buildListing(fileListingPath, this.context);
        return fileListingPath;
    }

    private Path createInputFileListingWithDiff(Job job, DistCpSync distCpSync) throws IOException {
        Path fileListingPath = this.getFileListingPath();
        SimpleCopyListing copyListing = new SimpleCopyListing(job.getConfiguration(), job.getCredentials(), distCpSync);
        copyListing.buildListing(fileListingPath, this.context);
        return fileListingPath;
    }

    protected Path getFileListingPath() throws IOException {
        String fileListPathStr = this.metaFolder + "/fileList.seq";
        Path path = new Path(fileListPathStr);
        return new Path(path.toUri().normalize().toString());
    }

    private Path createMetaFolderPath() throws Exception {
        Configuration configuration = this.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(configuration), (Configuration)configuration);
        Path metaFolderPath = new Path(stagingDir, PREFIX + String.valueOf(rand.nextInt()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Meta folder location: " + metaFolderPath));
        }
        configuration.set("distcp.meta.folder", metaFolderPath.toString());
        return metaFolderPath;
    }

    public static void main(String[] argv) {
        int exitCode;
        try {
            DistCp distCp = new DistCp();
            Cleanup CLEANUP = new Cleanup(distCp);
            ShutdownHookManager.get().addShutdownHook((Runnable)CLEANUP, 30);
            exitCode = ToolRunner.run((Configuration)DistCp.getDefaultConf(), (Tool)distCp, (String[])argv);
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't complete DistCp operation: ", (Throwable)e);
            exitCode = -999;
        }
        System.exit(exitCode);
    }

    private static Configuration getDefaultConf() {
        Configuration config = new Configuration();
        config.addResource(DISTCP_DEFAULT_XML);
        config.addResource(DISTCP_SITE_XML);
        return config;
    }

    private synchronized void cleanup() {
        try {
            if (this.metaFolder == null) {
                return;
            }
            this.jobFS.delete(this.metaFolder, true);
            this.metaFolder = null;
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to cleanup meta folder: " + this.metaFolder), (Throwable)e);
        }
    }

    private boolean isSubmitted() {
        return this.submitted;
    }

    private static class Cleanup
    implements Runnable {
        private final DistCp distCp;

        Cleanup(DistCp distCp) {
            this.distCp = distCp;
        }

        @Override
        public void run() {
            if (this.distCp.isSubmitted()) {
                return;
            }
            this.distCp.cleanup();
        }
    }
}

