/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.contract;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractContractDistCpTest
extends AbstractFSContractTestBase {
    @Rule
    public TestName testName = new TestName();
    private Configuration conf;
    private FileSystem localFS;
    private FileSystem remoteFS;
    private Path localDir;
    private Path remoteDir;

    protected Configuration createConfiguration() {
        Configuration newConf = new Configuration();
        newConf.set("mapred.job.tracker", "local");
        return newConf;
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        this.conf = this.getContract().getConf();
        this.localFS = FileSystem.getLocal((Configuration)this.conf);
        this.remoteFS = this.getFileSystem();
        Path testSubDir = new Path(((Object)((Object)this)).getClass().getSimpleName(), this.testName.getMethodName());
        this.localDir = this.localFS.makeQualified(new Path(new Path(GenericTestUtils.getTestDir().toURI()), testSubDir));
        AbstractContractDistCpTest.mkdirs(this.localFS, this.localDir);
        this.remoteDir = this.remoteFS.makeQualified(new Path(this.getContract().getTestPath(), testSubDir));
        AbstractContractDistCpTest.mkdirs(this.remoteFS, this.remoteDir);
    }

    @Test
    public void deepDirectoryStructureToRemote() throws Exception {
        this.describe("copy a deep directory structure from local to remote");
        this.deepDirectoryStructure(this.localFS, this.localDir, this.remoteFS, this.remoteDir);
    }

    @Test
    public void largeFilesToRemote() throws Exception {
        this.describe("copy multiple large files from local to remote");
        this.largeFiles(this.localFS, this.localDir, this.remoteFS, this.remoteDir);
    }

    @Test
    public void deepDirectoryStructureFromRemote() throws Exception {
        this.describe("copy a deep directory structure from remote to local");
        this.deepDirectoryStructure(this.remoteFS, this.remoteDir, this.localFS, this.localDir);
    }

    @Test
    public void largeFilesFromRemote() throws Exception {
        this.describe("copy multiple large files from remote to local");
        this.largeFiles(this.remoteFS, this.remoteDir, this.localFS, this.localDir);
    }

    private void deepDirectoryStructure(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstDir) throws Exception {
        Path inputDir = new Path(srcDir, "inputDir");
        Path inputSubDir1 = new Path(inputDir, "subDir1");
        Path inputSubDir2 = new Path(inputDir, "subDir2/subDir3");
        Path inputFile1 = new Path(inputDir, "file1");
        Path inputFile2 = new Path(inputSubDir1, "file2");
        Path inputFile3 = new Path(inputSubDir2, "file3");
        AbstractContractDistCpTest.mkdirs(srcFS, inputSubDir1);
        AbstractContractDistCpTest.mkdirs(srcFS, inputSubDir2);
        byte[] data1 = ContractTestUtils.dataset((int)100, (int)33, (int)43);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)inputFile1, (boolean)true, (byte[])data1);
        byte[] data2 = ContractTestUtils.dataset((int)200, (int)43, (int)53);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)inputFile2, (boolean)true, (byte[])data2);
        byte[] data3 = ContractTestUtils.dataset((int)300, (int)53, (int)63);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)inputFile3, (boolean)true, (byte[])data3);
        Path target = new Path(dstDir, "outputDir");
        this.runDistCp(inputDir, target);
        ContractTestUtils.assertIsDirectory((FileSystem)dstFS, (Path)target);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file1"), (byte[])data1);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/subDir1/file2"), (byte[])data2);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/subDir2/subDir3/file3"), (byte[])data3);
    }

    private void largeFiles(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstDir) throws Exception {
        Path inputDir = new Path(srcDir, "inputDir");
        Path inputFile1 = new Path(inputDir, "file1");
        Path inputFile2 = new Path(inputDir, "file2");
        Path inputFile3 = new Path(inputDir, "file3");
        AbstractContractDistCpTest.mkdirs(srcFS, inputDir);
        int fileSizeKb = this.conf.getInt("scale.test.distcp.file.size.kb", 10240);
        int fileSizeMb = fileSizeKb / 1024;
        AbstractContractDistCpTest.getLog().info("{} with file size {}", (Object)this.testName.getMethodName(), (Object)fileSizeMb);
        byte[] data1 = ContractTestUtils.dataset((int)((fileSizeMb + 1) * 1024 * 1024), (int)33, (int)43);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)inputFile1, (boolean)true, (byte[])data1);
        byte[] data2 = ContractTestUtils.dataset((int)((fileSizeMb + 2) * 1024 * 1024), (int)43, (int)53);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)inputFile2, (boolean)true, (byte[])data2);
        byte[] data3 = ContractTestUtils.dataset((int)((fileSizeMb + 3) * 1024 * 1024), (int)53, (int)63);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)inputFile3, (boolean)true, (byte[])data3);
        Path target = new Path(dstDir, "outputDir");
        this.runDistCp(inputDir, target);
        ContractTestUtils.assertIsDirectory((FileSystem)dstFS, (Path)target);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file1"), (byte[])data1);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file2"), (byte[])data2);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file3"), (byte[])data3);
    }

    private void runDistCp(Path src, Path dst) throws Exception {
        DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(src), dst).build();
        Job job = new DistCp(this.conf, options).execute();
        AbstractContractDistCpTest.assertNotNull((String)"Unexpected null job returned from DistCp execution.", (Object)job);
        AbstractContractDistCpTest.assertTrue((String)"DistCp job did not complete.", (boolean)job.isComplete());
        AbstractContractDistCpTest.assertTrue((String)"DistCp job did not complete successfully.", (boolean)job.isSuccessful());
    }

    private static void mkdirs(FileSystem fs, Path dir) throws Exception {
        AbstractContractDistCpTest.assertTrue((String)("Failed to mkdir " + dir), (boolean)fs.mkdirs(dir));
    }
}

