/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpConstants;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.util.DistCpUtils;

public class CopyCommitter
extends FileOutputCommitter {
    private static final Log LOG = LogFactory.getLog(CopyCommitter.class);
    private final TaskAttemptContext taskAttemptContext;
    private boolean syncFolder = false;
    private boolean overwrite = false;
    private boolean targetPathExists = true;
    private boolean ignoreFailures = false;

    public CopyCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.taskAttemptContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitJob(JobContext jobContext) throws IOException {
        Configuration conf = jobContext.getConfiguration();
        this.syncFolder = conf.getBoolean("distcp.sync.folders", false);
        this.overwrite = conf.getBoolean("distcp.copy.overwrite", false);
        this.targetPathExists = conf.getBoolean("distcp.target.path.exists", true);
        this.ignoreFailures = conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false);
        this.concatFileChunks(conf);
        super.commitJob(jobContext);
        this.cleanupTempFiles(jobContext);
        String attributes = conf.get("distcp.preserve.status");
        boolean preserveRawXattrs = conf.getBoolean("distcp.preserve.rawxattrs", false);
        if (attributes != null && !attributes.isEmpty() || preserveRawXattrs) {
            this.preserveFileAttributesForDirectories(conf);
        }
        try {
            if (conf.getBoolean("distcp.delete.missing.source", false)) {
                this.deleteMissing(conf);
            } else if (conf.getBoolean("distcp.atomic.copy", false)) {
                this.commitData(conf);
            }
            this.taskAttemptContext.setStatus("Commit Successful");
        }
        finally {
            this.cleanup(conf);
        }
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        try {
            super.abortJob(jobContext, state);
        }
        finally {
            this.cleanupTempFiles(jobContext);
            this.cleanup(jobContext.getConfiguration());
        }
    }

    private void cleanupTempFiles(JobContext context) {
        try {
            Configuration conf = context.getConfiguration();
            Path targetWorkPath = new Path(conf.get("distcp.target.work.path"));
            FileSystem targetFS = targetWorkPath.getFileSystem(conf);
            String jobId = context.getJobID().toString();
            this.deleteAttemptTempFiles(targetWorkPath, targetFS, jobId);
            this.deleteAttemptTempFiles(targetWorkPath.getParent(), targetFS, jobId);
        }
        catch (Throwable t) {
            LOG.warn((Object)"Unable to cleanup temp files", t);
        }
    }

    private void deleteAttemptTempFiles(Path targetWorkPath, FileSystem targetFS, String jobId) throws IOException {
        if (targetWorkPath == null) {
            return;
        }
        FileStatus[] tempFiles = targetFS.globStatus(new Path(targetWorkPath, ".distcp.tmp." + jobId.replaceAll("job", "attempt") + "*"));
        if (tempFiles != null && tempFiles.length > 0) {
            for (FileStatus file : tempFiles) {
                LOG.info((Object)("Cleaning up " + file.getPath()));
                targetFS.delete(file.getPath(), false);
            }
        }
    }

    private void cleanup(Configuration conf) {
        Path metaFolder = new Path(conf.get("distcp.meta.folder"));
        try {
            FileSystem fs = metaFolder.getFileSystem(conf);
            LOG.info((Object)("Cleaning up temporary work folder: " + metaFolder));
            fs.delete(metaFolder, true);
        }
        catch (IOException ignore) {
            LOG.error((Object)"Exception encountered ", (Throwable)ignore);
        }
    }

    private boolean isFileNotFoundException(IOException e) {
        if (e instanceof FileNotFoundException) {
            return true;
        }
        if (e instanceof RemoteException) {
            return ((RemoteException)e).unwrapRemoteException() instanceof FileNotFoundException;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatFileChunks(Configuration conf) throws IOException {
        LOG.info((Object)"concat file chunks ...");
        String spath = conf.get("distcp.listing.file.path");
        if (spath == null || spath.isEmpty()) {
            return;
        }
        Path sourceListing = new Path(spath);
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sourceListing)});
        Path targetRoot = new Path(conf.get("distcp.target.work.path"));
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            CopyListingFileStatus lastFileStatus = null;
            LinkedList<Path> allChunkPaths = new LinkedList<Path>();
            while (sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                if (srcFileStatus.isDirectory()) continue;
                Path targetFile = new Path(targetRoot.toString() + "/" + srcRelPath);
                Path targetFileChunkPath = DistCpUtils.getSplitChunkPath(targetFile, srcFileStatus);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("  add " + targetFileChunkPath + " to concat."));
                }
                allChunkPaths.add(targetFileChunkPath);
                if (srcFileStatus.getChunkOffset() + srcFileStatus.getChunkLength() == srcFileStatus.getLen()) {
                    block13: {
                        try {
                            this.concatFileChunks(conf, targetFile, allChunkPaths);
                        }
                        catch (IOException e) {
                            if (this.isFileNotFoundException(e)) break block13;
                            String emsg = "Failed to concat chunk files for " + targetFile;
                            if (!this.ignoreFailures) {
                                throw new IOException(emsg, e);
                            }
                            LOG.warn((Object)emsg, (Throwable)e);
                        }
                    }
                    allChunkPaths.clear();
                    lastFileStatus = null;
                    continue;
                }
                if (lastFileStatus == null) {
                    lastFileStatus = new CopyListingFileStatus(srcFileStatus);
                    continue;
                }
                if (!srcFileStatus.getPath().equals((Object)lastFileStatus.getPath()) || srcFileStatus.getChunkOffset() != lastFileStatus.getChunkOffset() + lastFileStatus.getChunkLength()) {
                    String emsg = "Inconsistent sequence file: current chunk file " + srcFileStatus + " doesnt match prior entry " + lastFileStatus;
                    if (!this.ignoreFailures) {
                        throw new IOException(emsg);
                    }
                    LOG.warn((Object)(emsg + ", skipping concat this set."));
                    continue;
                }
                lastFileStatus.setChunkOffset(srcFileStatus.getChunkOffset());
                lastFileStatus.setChunkLength(srcFileStatus.getChunkLength());
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preserveFileAttributesForDirectories(Configuration conf) throws IOException {
        String attrSymbols = conf.get("distcp.preserve.status");
        boolean syncOrOverwrite = this.syncFolder || this.overwrite;
        LOG.info((Object)("About to preserve attributes: " + attrSymbols));
        EnumSet<DistCpOptions.FileAttribute> attributes = DistCpUtils.unpackAttributes(attrSymbols);
        boolean preserveRawXattrs = conf.getBoolean("distcp.preserve.rawxattrs", false);
        Path sourceListing = new Path(conf.get("distcp.listing.file.path"));
        FileSystem clusterFS = sourceListing.getFileSystem(conf);
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sourceListing)});
        long totalLen = clusterFS.getFileStatus(sourceListing).getLen();
        Path targetRoot = new Path(conf.get("distcp.target.work.path"));
        long preservedEntries = 0L;
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            while (sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                Path targetFile;
                if (!srcFileStatus.isDirectory() || targetRoot.equals((Object)(targetFile = new Path(targetRoot.toString() + "/" + srcRelPath))) && syncOrOverwrite) continue;
                FileSystem targetFS = targetFile.getFileSystem(conf);
                DistCpUtils.preserve(targetFS, targetFile, srcFileStatus, attributes, preserveRawXattrs);
                this.taskAttemptContext.progress();
                this.taskAttemptContext.setStatus("Preserving status on directory entries. [" + sourceReader.getPosition() * 100L / totalLen + "%]");
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
        }
        LOG.info((Object)("Preserved status on " + preservedEntries + " dir entries on target"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMissing(Configuration conf) throws IOException {
        LOG.info((Object)"-delete option is enabled. About to remove entries from target that are missing in source");
        Path sourceListing = new Path(conf.get("distcp.listing.file.path"));
        FileSystem clusterFS = sourceListing.getFileSystem(conf);
        Path sortedSourceListing = DistCpUtils.sortListing(clusterFS, conf, sourceListing);
        Path targetListing = new Path(sourceListing.getParent(), "targetListing.seq");
        GlobbedCopyListing target = new GlobbedCopyListing(new Configuration(conf), null);
        ArrayList<Path> targets = new ArrayList<Path>(1);
        Path targetFinalPath = new Path(conf.get("distcp.target.final.path"));
        targets.add(targetFinalPath);
        Path resultNonePath = Path.getPathWithoutSchemeAndAuthority((Path)targetFinalPath).toString().startsWith("/.reserved/raw") ? DistCpConstants.RAW_NONE_PATH : DistCpConstants.NONE_PATH;
        DistCpOptions options = new DistCpOptions.Builder(targets, resultNonePath).withOverwrite(this.overwrite).withSyncFolder(this.syncFolder).build();
        DistCpContext distCpContext = new DistCpContext(options);
        distCpContext.setTargetPathExists(this.targetPathExists);
        target.buildListing(targetListing, distCpContext);
        Path sortedTargetListing = DistCpUtils.sortListing(clusterFS, conf, targetListing);
        long totalLen = clusterFS.getFileStatus(sortedTargetListing).getLen();
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedSourceListing)});
        SequenceFile.Reader targetReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedTargetListing)});
        long deletedEntries = 0L;
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            CopyListingFileStatus trgtFileStatus = new CopyListingFileStatus();
            Text trgtRelPath = new Text();
            FileSystem targetFS = targetFinalPath.getFileSystem(conf);
            boolean srcAvailable = sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus);
            while (targetReader.next((Writable)trgtRelPath, (Writable)trgtFileStatus)) {
                boolean result;
                while (srcAvailable && trgtRelPath.compareTo((BinaryComparable)srcRelPath) > 0) {
                    srcAvailable = sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus);
                }
                if (srcAvailable && trgtRelPath.equals((Object)srcRelPath)) continue;
                boolean bl = result = targetFS.delete(trgtFileStatus.getPath(), true) || !targetFS.exists(trgtFileStatus.getPath());
                if (result) {
                    LOG.info((Object)("Deleted " + trgtFileStatus.getPath() + " - Missing at source"));
                    ++deletedEntries;
                } else {
                    throw new IOException("Unable to delete " + trgtFileStatus.getPath());
                }
                this.taskAttemptContext.progress();
                this.taskAttemptContext.setStatus("Deleting missing files from target. [" + targetReader.getPosition() * 100L / totalLen + "%]");
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
            IOUtils.closeStream((Closeable)targetReader);
        }
        LOG.info((Object)("Deleted " + deletedEntries + " from target: " + targets.get(0)));
    }

    private void commitData(Configuration conf) throws IOException {
        Path workDir = new Path(conf.get("distcp.target.work.path"));
        Path finalDir = new Path(conf.get("distcp.target.final.path"));
        FileSystem targetFS = workDir.getFileSystem(conf);
        LOG.info((Object)("Atomic commit enabled. Moving " + workDir + " to " + finalDir));
        if (targetFS.exists(finalDir) && targetFS.exists(workDir)) {
            LOG.error((Object)("Pre-existing final-path found at: " + finalDir));
            throw new IOException("Target-path can't be committed to because it exists at " + finalDir + ". Copied data is in temp-dir: " + workDir + ". ");
        }
        boolean result = targetFS.rename(workDir, finalDir);
        if (!result) {
            LOG.warn((Object)"Rename failed. Perhaps data already moved. Verifying...");
            boolean bl = result = targetFS.exists(finalDir) && !targetFS.exists(workDir);
        }
        if (!result) {
            LOG.error((Object)("Unable to commit data to " + finalDir));
            throw new IOException("Atomic commit failed. Temporary data in " + workDir + ", Unable to move to " + finalDir);
        }
        LOG.info((Object)("Data committed successfully to " + finalDir));
        this.taskAttemptContext.setStatus("Data committed successfully to " + finalDir);
    }

    private void concatFileChunks(Configuration conf, Path targetFile, LinkedList<Path> allChunkPaths) throws IOException {
        if (allChunkPaths.size() == 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + targetFile + " allChunkSize+ " + allChunkPaths.size()));
        }
        FileSystem dstfs = targetFile.getFileSystem(conf);
        Path firstChunkFile = allChunkPaths.removeFirst();
        Path[] restChunkFiles = new Path[allChunkPaths.size()];
        allChunkPaths.toArray(restChunkFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat: firstchunk: " + dstfs.getFileStatus(firstChunkFile)));
            int i = 0;
            for (Path f : restChunkFiles) {
                LOG.debug((Object)("concat: other chunk: " + i + ": " + dstfs.getFileStatus(f)));
                ++i;
            }
        }
        dstfs.concat(firstChunkFile, restChunkFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat: result: " + dstfs.getFileStatus(firstChunkFile)));
        }
        CopyCommitter.rename(dstfs, firstChunkFile, targetFile);
    }

    private static void rename(FileSystem destFileSys, Path tmp, Path dst) throws IOException {
        try {
            if (destFileSys.exists(dst)) {
                destFileSys.delete(dst, true);
            }
            destFileSys.rename(tmp, dst);
        }
        catch (IOException ioe) {
            throw new IOException("Fail to rename tmp file (=" + tmp + ") to destination file (=" + dst + ")", ioe);
        }
    }
}

