/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileBasedCopyListing;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFileBasedCopyListing {
    private static final Log LOG = LogFactory.getLog(TestFileBasedCopyListing.class);
    private static final Credentials CREDENTIALS = new Credentials();
    private static final Configuration config = new Configuration();
    private static MiniDFSCluster cluster;
    private static FileSystem fs;
    private static Map<String, String> map;

    @BeforeClass
    public static void create() throws IOException {
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).format(true).build();
        fs = cluster.getFileSystem();
        TestFileBasedCopyListing.buildExpectedValuesMap();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static void buildExpectedValuesMap() {
        map.put("/file1", "/tmp/singlefile1/file1");
        map.put("/file2", "/tmp/singlefile2/file2");
        map.put("/file3", "/tmp/multifile/file3");
        map.put("/file4", "/tmp/multifile/file4");
        map.put("/file5", "/tmp/multifile/file5");
        map.put("/multifile/file3", "/tmp/multifile/file3");
        map.put("/multifile/file4", "/tmp/multifile/file4");
        map.put("/multifile/file5", "/tmp/multifile/file5");
        map.put("/Ufile3", "/tmp/Umultifile/Ufile3");
        map.put("/Ufile4", "/tmp/Umultifile/Ufile4");
        map.put("/Ufile5", "/tmp/Umultifile/Ufile5");
        map.put("/dir1", "/tmp/singledir/dir1");
        map.put("/singledir/dir1", "/tmp/singledir/dir1");
        map.put("/dir2", "/tmp/singledir/dir2");
        map.put("/singledir/dir2", "/tmp/singledir/dir2");
        map.put("/Udir1", "/tmp/Usingledir/Udir1");
        map.put("/Udir2", "/tmp/Usingledir/Udir2");
        map.put("/dir2/file6", "/tmp/singledir/dir2/file6");
        map.put("/singledir/dir2/file6", "/tmp/singledir/dir2/file6");
        map.put("/file7", "/tmp/singledir1/dir3/file7");
        map.put("/file8", "/tmp/singledir1/dir3/file8");
        map.put("/file9", "/tmp/singledir1/dir3/file9");
        map.put("/dir3/file7", "/tmp/singledir1/dir3/file7");
        map.put("/dir3/file8", "/tmp/singledir1/dir3/file8");
        map.put("/dir3/file9", "/tmp/singledir1/dir3/file9");
        map.put("/Ufile7", "/tmp/Usingledir1/Udir3/Ufile7");
        map.put("/Ufile8", "/tmp/Usingledir1/Udir3/Ufile8");
        map.put("/Ufile9", "/tmp/Usingledir1/Udir3/Ufile9");
    }

    @Test
    public void testSingleFileMissingTarget() {
        this.caseSingleFileMissingTarget(false);
        this.caseSingleFileMissingTarget(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileMissingTarget(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/singlefile1/file1");
            this.createFiles("/tmp/singlefile1/file1");
            this.runTest(listFile, target, false, sync);
            this.checkResult(listFile, 0);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testSingleFileTargetFile() {
        this.caseSingleFileTargetFile(false);
        this.caseSingleFileTargetFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileTargetFile(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/singlefile1/file1");
            this.createFiles("/tmp/singlefile1/file1", target.toString());
            this.runTest(listFile, target, false, sync);
            this.checkResult(listFile, 0);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testSingleFileTargetDir() {
        this.caseSingleFileTargetDir(false);
        this.caseSingleFileTargetDir(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileTargetDir(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/singlefile2/file2");
            this.createFiles("/tmp/singlefile2/file2");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, sync);
            this.checkResult(listFile, 1);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testSingleDirTargetMissing() {
        this.caseSingleDirTargetMissing(false);
        this.caseSingleDirTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleDirTargetMissing(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/singledir");
            this.mkdirs("/tmp/singledir/dir1");
            this.runTest(listFile, target, false, sync);
            this.checkResult(listFile, 1);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testSingleDirTargetPresent() {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/singledir");
            this.mkdirs("/tmp/singledir/dir1");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true);
            this.checkResult(listFile, 1);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testUpdateSingleDirTargetPresent() {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/Usingledir");
            this.mkdirs("/tmp/Usingledir/Udir1");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, true);
            this.checkResult(listFile, 1);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testMultiFileTargetPresent() {
        this.caseMultiFileTargetPresent(false);
        this.caseMultiFileTargetPresent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiFileTargetPresent(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, sync);
            this.checkResult(listFile, 3);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testMultiFileTargetMissing() {
        this.caseMultiFileTargetMissing(false);
        this.caseMultiFileTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiFileTargetMissing(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.runTest(listFile, target, false, sync);
            this.checkResult(listFile, 3);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testMultiDirTargetPresent() {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/multifile", "/tmp/singledir");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.mkdirs(target.toString(), "/tmp/singledir/dir1");
            this.runTest(listFile, target, true);
            this.checkResult(listFile, 4);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testUpdateMultiDirTargetPresent() {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/Umultifile", "/tmp/Usingledir");
            this.createFiles("/tmp/Umultifile/Ufile3", "/tmp/Umultifile/Ufile4", "/tmp/Umultifile/Ufile5");
            this.mkdirs(target.toString(), "/tmp/Usingledir/Udir1");
            this.runTest(listFile, target, true);
            this.checkResult(listFile, 4);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testMultiDirTargetMissing() {
        this.caseMultiDirTargetMissing(false);
        this.caseMultiDirTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiDirTargetMissing(boolean sync) {
        try {
            Path listFile = new Path("/tmp/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/multifile", "/tmp/singledir");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.mkdirs("/tmp/singledir/dir1");
            this.runTest(listFile, target, sync);
            this.checkResult(listFile, 4);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    @Test
    public void testGlobTargetMissingSingleLevel() {
        this.caseGlobTargetMissingSingleLevel(false);
        this.caseGlobTargetMissingSingleLevel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseGlobTargetMissingSingleLevel(boolean sync) {
        try {
            Path listFile = new Path("/tmp1/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/*");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.createFiles("/tmp/singledir/dir2/file6");
            this.runTest(listFile, target, sync);
            this.checkResult(listFile, 5);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
            TestDistCpUtils.delete(fs, "/tmp1");
        }
    }

    @Test
    public void testGlobTargetMissingMultiLevel() {
        this.caseGlobTargetMissingMultiLevel(false);
        this.caseGlobTargetMissingMultiLevel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseGlobTargetMissingMultiLevel(boolean sync) {
        try {
            Path listFile = new Path("/tmp1/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/*/*");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.createFiles("/tmp/singledir1/dir3/file7", "/tmp/singledir1/dir3/file8", "/tmp/singledir1/dir3/file9");
            this.runTest(listFile, target, sync);
            this.checkResult(listFile, 6);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
            TestDistCpUtils.delete(fs, "/tmp1");
        }
    }

    @Test
    public void testGlobTargetDirMultiLevel() {
        try {
            Path listFile = new Path("/tmp1/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/*/*");
            this.createFiles("/tmp/multifile/file3", "/tmp/multifile/file4", "/tmp/multifile/file5");
            this.createFiles("/tmp/singledir1/dir3/file7", "/tmp/singledir1/dir3/file8", "/tmp/singledir1/dir3/file9");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true);
            this.checkResult(listFile, 6);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
            TestDistCpUtils.delete(fs, "/tmp1");
        }
    }

    @Test
    public void testUpdateGlobTargetDirMultiLevel() {
        try {
            Path listFile = new Path("/tmp1/listing");
            Path target = new Path("/tmp/target");
            this.addEntries(listFile, "/tmp/*/*");
            this.createFiles("/tmp/Umultifile/Ufile3", "/tmp/Umultifile/Ufile4", "/tmp/Umultifile/Ufile5");
            this.createFiles("/tmp/Usingledir1/Udir3/Ufile7", "/tmp/Usingledir1/Udir3/Ufile8", "/tmp/Usingledir1/Udir3/Ufile9");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true);
            this.checkResult(listFile, 6);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing build listing", (Throwable)e);
            Assert.fail((String)"build listing failure");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
            TestDistCpUtils.delete(fs, "/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntries(Path listFile, String ... entries) throws IOException {
        try (FSDataOutputStream out = fs.create(listFile);){
            for (String entry : entries) {
                out.write(entry.getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(String ... entries) throws IOException {
        for (String entry : entries) {
            try (FSDataOutputStream out = fs.create(new Path(entry));){
                out.write(entry.getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    private void mkdirs(String ... entries) throws IOException {
        for (String entry : entries) {
            fs.mkdirs(new Path(entry));
        }
    }

    private void runTest(Path listFile, Path target, boolean targetExists) throws IOException {
        this.runTest(listFile, target, targetExists, true);
    }

    private void runTest(Path listFile, Path target, boolean targetExists, boolean sync) throws IOException {
        FileBasedCopyListing listing = new FileBasedCopyListing(config, CREDENTIALS);
        DistCpOptions options = new DistCpOptions.Builder(listFile, target).withSyncFolder(sync).build();
        DistCpContext context = new DistCpContext(options);
        context.setTargetPathExists(targetExists);
        listing.buildListing(listFile, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResult(Path listFile, int count) throws IOException {
        if (count == 0) {
            return;
        }
        int recCount = 0;
        SequenceFile.Reader reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)listFile)});
        try {
            Text relPath = new Text();
            CopyListingFileStatus fileStatus = new CopyListingFileStatus();
            while (reader.next((Writable)relPath, (Writable)fileStatus)) {
                if (fileStatus.isDirectory() && relPath.toString().equals("")) continue;
                Assert.assertEquals((Object)fileStatus.getPath().toUri().getPath(), (Object)map.get(relPath.toString()));
                ++recCount;
            }
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
        Assert.assertEquals((long)recCount, (long)count);
    }

    static {
        map = new HashMap<String, String>();
    }
}

