/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.mapred.CopyCommitter;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCopyCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(TestCopyCommitter.class);
    private static final Random rand = new Random();
    private static final long BLOCK_SIZE = 1024L;
    private static final Credentials CREDENTIALS = new Credentials();
    public static final int PORT = 39737;
    private static Configuration clusterConfig;
    private static MiniDFSCluster cluster;
    private Configuration config;

    private static Job getJobForClient() throws IOException {
        Job job = Job.getInstance((Configuration)new Configuration());
        job.getConfiguration().set("mapred.job.tracker", "localhost:39737");
        job.setInputFormatClass(NullInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    @BeforeClass
    public static void create() throws IOException {
        clusterConfig = TestCopyCommitter.getJobForClient().getConfiguration();
        clusterConfig.setLong("mapred.total.bytes.expected", 0L);
        clusterConfig.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        clusterConfig.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(clusterConfig).numDataNodes(1).format(true).build();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void createMetaFolder() throws IOException {
        this.config = new Configuration(clusterConfig);
        this.config.set("distcp.meta.folder", "/meta");
        Path meta = new Path("/meta");
        cluster.getFileSystem().mkdirs(meta);
    }

    @After
    public void cleanupMetaFolder() throws IOException {
        Path meta = new Path("/meta");
        if (cluster.getFileSystem().exists(meta)) {
            cluster.getFileSystem().delete(meta, true);
            Assert.fail((String)"Expected meta folder to be deleted");
        }
    }

    @Test
    public void testNoCommitAction() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
        committer.commitJob((JobContext)jobContext);
        Assert.assertEquals((Object)"Commit Successful", (Object)taskAttemptContext.getStatus());
        committer.commitJob((JobContext)jobContext);
        Assert.assertEquals((Object)"Commit Successful", (Object)taskAttemptContext.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveStatus() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            FsPermission sourcePerm = new FsPermission(511);
            FsPermission initialPerm = new FsPermission(448);
            String sourceBase = TestDistCpUtils.createTestSetup(fs, sourcePerm);
            String targetBase = TestDistCpUtils.createTestSetup(fs, initialPerm);
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path("/out")).preserve(DistCpOptions.FileAttribute.PERMISSION).build();
            options.appendToConf(conf);
            DistCpContext context = new DistCpContext(options);
            context.setTargetPathExists(false);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + rand.nextLong());
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.final.path", targetBase);
            committer.commitJob((JobContext)jobContext);
            this.checkDirectoryPermissions(fs, targetBase, sourcePerm);
            committer.commitJob((JobContext)jobContext);
            this.checkDirectoryPermissions(fs, targetBase, sourcePerm);
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, "/tmp1");
            conf.unset("distcp.preserve.status");
            throw throwable;
        }
        TestDistCpUtils.delete(fs, "/tmp1");
        conf.unset("distcp.preserve.status");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveStatusWithAtomicCommit() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            FsPermission sourcePerm = new FsPermission(511);
            FsPermission initialPerm = new FsPermission(448);
            String sourceBase = TestDistCpUtils.createTestSetup(fs, sourcePerm);
            String workBase = TestDistCpUtils.createTestSetup(fs, initialPerm);
            String targetBase = "/tmp1/" + rand.nextLong();
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path("/out")).preserve(DistCpOptions.FileAttribute.PERMISSION).build();
            options.appendToConf(conf);
            DistCpContext context = new DistCpContext(options);
            context.setTargetPathExists(false);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + rand.nextLong());
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.final.path", targetBase);
            conf.set("distcp.target.work.path", workBase);
            conf.setBoolean("distcp.atomic.copy", true);
            committer.commitJob((JobContext)jobContext);
            this.checkDirectoryPermissions(fs, targetBase, sourcePerm);
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, "/tmp1");
            conf.unset("distcp.preserve.status");
            throw throwable;
        }
        TestDistCpUtils.delete(fs, "/tmp1");
        conf.unset("distcp.preserve.status");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMissing() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            String sourceBase = TestDistCpUtils.createTestSetup(fs, FsPermission.getDefault());
            String targetBase = TestDistCpUtils.createTestSetup(fs, FsPermission.getDefault());
            String targetBaseAdd = TestDistCpUtils.createTestSetup(fs, FsPermission.getDefault());
            fs.rename(new Path(targetBaseAdd), new Path(targetBase));
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path("/out")).withSyncFolder(true).withDeleteMissing(true).build();
            options.appendToConf(conf);
            DistCpContext context = new DistCpContext(options);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.work.path", targetBase);
            conf.set("distcp.target.final.path", targetBase);
            committer.commitJob((JobContext)jobContext);
            TestDistCpUtils.verifyFoldersAreInSync(fs, targetBase, sourceBase);
            TestDistCpUtils.verifyFoldersAreInSync(fs, sourceBase, targetBase);
            committer.commitJob((JobContext)jobContext);
            TestDistCpUtils.verifyFoldersAreInSync(fs, targetBase, sourceBase);
            TestDistCpUtils.verifyFoldersAreInSync(fs, sourceBase, targetBase);
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, "/tmp1");
            conf.set("distcp.delete.missing.source", "false");
            throw throwable;
        }
        TestDistCpUtils.delete(fs, "/tmp1");
        conf.set("distcp.delete.missing.source", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMissingWithOnlyFile() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            String sourceBase = TestDistCpUtils.createTestSetupWithOnlyFile(fs, FsPermission.getDefault());
            String targetBase = TestDistCpUtils.createTestSetupWithOnlyFile(fs, FsPermission.getDefault());
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path(targetBase)).withSyncFolder(true).withDeleteMissing(true).build();
            options.appendToConf(conf);
            DistCpContext context = new DistCpContext(options);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path(sourceBase);
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.work.path", targetBase);
            conf.set("distcp.target.final.path", targetBase);
            committer.commitJob((JobContext)jobContext);
            TestDistCpUtils.verifyFoldersAreInSync(fs, targetBase, sourceBase);
            TestDistCpUtils.verifyFoldersAreInSync(fs, sourceBase, targetBase);
            committer.commitJob((JobContext)jobContext);
            TestDistCpUtils.verifyFoldersAreInSync(fs, targetBase, sourceBase);
            TestDistCpUtils.verifyFoldersAreInSync(fs, sourceBase, targetBase);
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, "/tmp1");
            conf.set("distcp.delete.missing.source", "false");
            throw throwable;
        }
        TestDistCpUtils.delete(fs, "/tmp1");
        conf.set("distcp.delete.missing.source", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveTimeWithDeleteMiss() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            String sourceBase = TestDistCpUtils.createTestSetup(fs, FsPermission.getDefault());
            String targetBase = TestDistCpUtils.createTestSetup(fs, FsPermission.getDefault());
            String targetBaseAdd = TestDistCpUtils.createTestSetup(fs, FsPermission.getDefault());
            fs.rename(new Path(targetBaseAdd), new Path(targetBase));
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path("/out")).withSyncFolder(true).withDeleteMissing(true).preserve(DistCpOptions.FileAttribute.TIMES).build();
            options.appendToConf(conf);
            DistCpContext context = new DistCpContext(options);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.work.path", targetBase);
            conf.set("distcp.target.final.path", targetBase);
            Path sourceListing = new Path(conf.get("distcp.listing.file.path"));
            SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sourceListing)});
            Path targetRoot = new Path(targetBase);
            committer.commitJob((JobContext)jobContext);
            this.checkDirectoryTimes(fs, sourceReader, targetRoot);
            committer.commitJob((JobContext)jobContext);
            this.checkDirectoryTimes(fs, sourceReader, targetRoot);
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, "/tmp1");
            conf.unset("distcp.preserve.status");
            conf.set("distcp.delete.missing.source", "false");
            throw throwable;
        }
        TestDistCpUtils.delete(fs, "/tmp1");
        conf.unset("distcp.preserve.status");
        conf.set("distcp.delete.missing.source", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMissingFlatInterleavedFiles() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            String sourceBase = "/tmp1/" + String.valueOf(rand.nextLong());
            String targetBase = "/tmp1/" + String.valueOf(rand.nextLong());
            TestDistCpUtils.createFile(fs, sourceBase + "/1");
            TestDistCpUtils.createFile(fs, sourceBase + "/3");
            TestDistCpUtils.createFile(fs, sourceBase + "/4");
            TestDistCpUtils.createFile(fs, sourceBase + "/5");
            TestDistCpUtils.createFile(fs, sourceBase + "/7");
            TestDistCpUtils.createFile(fs, sourceBase + "/8");
            TestDistCpUtils.createFile(fs, sourceBase + "/9");
            TestDistCpUtils.createFile(fs, targetBase + "/2");
            TestDistCpUtils.createFile(fs, targetBase + "/4");
            TestDistCpUtils.createFile(fs, targetBase + "/5");
            TestDistCpUtils.createFile(fs, targetBase + "/7");
            TestDistCpUtils.createFile(fs, targetBase + "/9");
            TestDistCpUtils.createFile(fs, targetBase + "/A");
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path("/out")).withSyncFolder(true).withDeleteMissing(true).build();
            options.appendToConf(conf);
            DistCpContext context = new DistCpContext(options);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.work.path", targetBase);
            conf.set("distcp.target.final.path", targetBase);
            committer.commitJob((JobContext)jobContext);
            TestDistCpUtils.verifyFoldersAreInSync(fs, targetBase, sourceBase);
            Assert.assertEquals((long)4L, (long)fs.listStatus(new Path(targetBase)).length);
            committer.commitJob((JobContext)jobContext);
            TestDistCpUtils.verifyFoldersAreInSync(fs, targetBase, sourceBase);
            Assert.assertEquals((long)4L, (long)fs.listStatus(new Path(targetBase)).length);
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, "/tmp1");
            conf.set("distcp.delete.missing.source", "false");
            throw throwable;
        }
        TestDistCpUtils.delete(fs, "/tmp1");
        conf.set("distcp.delete.missing.source", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicCommitMissingFinal() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        String workPath = "/tmp1/" + String.valueOf(rand.nextLong());
        String finalPath = "/tmp1/" + String.valueOf(rand.nextLong());
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            fs.mkdirs(new Path(workPath));
            conf.set("distcp.target.work.path", workPath);
            conf.set("distcp.target.final.path", finalPath);
            conf.setBoolean("distcp.atomic.copy", true);
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Work path", (Path)new Path(workPath));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"Final path", (Path)new Path(finalPath));
            committer.commitJob((JobContext)jobContext);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"Work path", (Path)new Path(workPath));
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Final path", (Path)new Path(finalPath));
            committer.commitJob((JobContext)jobContext);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"Work path", (Path)new Path(workPath));
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Final path", (Path)new Path(finalPath));
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, workPath);
            TestDistCpUtils.delete(fs, finalPath);
            conf.setBoolean("distcp.atomic.copy", false);
            throw throwable;
        }
        TestDistCpUtils.delete(fs, workPath);
        TestDistCpUtils.delete(fs, finalPath);
        conf.setBoolean("distcp.atomic.copy", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicCommitExistingFinal() throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        String workPath = "/tmp1/" + String.valueOf(rand.nextLong());
        String finalPath = "/tmp1/" + String.valueOf(rand.nextLong());
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            fs.mkdirs(new Path(workPath));
            fs.mkdirs(new Path(finalPath));
            conf.set("distcp.target.work.path", workPath);
            conf.set("distcp.target.final.path", finalPath);
            conf.setBoolean("distcp.atomic.copy", true);
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Work path", (Path)new Path(workPath));
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Final path", (Path)new Path(finalPath));
            try {
                committer.commitJob((JobContext)jobContext);
                Assert.fail((String)"Should not be able to atomic-commit to pre-existing path.");
            }
            catch (Exception exception) {
                ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Work path", (Path)new Path(workPath));
                ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Final path", (Path)new Path(finalPath));
                LOG.info("Atomic-commit Test pass.");
            }
        }
        catch (Throwable throwable) {
            TestDistCpUtils.delete(fs, workPath);
            TestDistCpUtils.delete(fs, finalPath);
            conf.setBoolean("distcp.atomic.copy", false);
            throw throwable;
        }
        TestDistCpUtils.delete(fs, workPath);
        TestDistCpUtils.delete(fs, finalPath);
        conf.setBoolean("distcp.atomic.copy", false);
    }

    @Test
    public void testCommitWithChecksumMismatchAndSkipCrc() throws IOException {
        this.testCommitWithChecksumMismatch(true);
    }

    @Test
    public void testCommitWithChecksumMismatchWithoutSkipCrc() throws IOException {
        this.testCommitWithChecksumMismatch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCommitWithChecksumMismatch(boolean skipCrc) throws IOException {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(this.config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)conf);
            String sourceBase = "/tmp1/" + String.valueOf(rand.nextLong());
            String targetBase = "/tmp1/" + String.valueOf(rand.nextLong());
            int blocksPerChunk = 5;
            String srcFilename = "/srcdata";
            this.createSrcAndWorkFilesWithDifferentChecksum(fs, targetBase, sourceBase, srcFilename, blocksPerChunk);
            DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path(sourceBase)), new Path("/out")).withBlocksPerChunk(blocksPerChunk).withCRC(skipCrc).build();
            options.appendToConf(conf);
            conf.setBoolean("distcp.simplelisting.randomize.files", false);
            DistCpContext context = new DistCpContext(options);
            context.setTargetPathExists(false);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
            listing.buildListing(listingFile, context);
            conf.set("distcp.target.work.path", targetBase);
            conf.set("distcp.target.final.path", targetBase);
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            try {
                committer.commitJob((JobContext)jobContext);
                if (!skipCrc) {
                    Assert.fail((String)"Expected commit to fail");
                }
                Path sourcePath = new Path(sourceBase + srcFilename);
                CopyListingFileStatus sourceCurrStatus = new CopyListingFileStatus(fs.getFileStatus(sourcePath));
                Assert.assertFalse((boolean)DistCpUtils.checksumsAreEqual((FileSystem)fs, (Path)new Path(sourceBase + srcFilename), null, (FileSystem)fs, (Path)new Path(targetBase + srcFilename), (long)sourceCurrStatus.getLen()));
            }
            catch (IOException exception) {
                if (skipCrc) {
                    LOG.error("Unexpected exception is found", (Throwable)exception);
                    throw exception;
                }
                Throwable cause = exception.getCause();
                GenericTestUtils.assertExceptionContains((String)"Checksum mismatch", (Throwable)cause);
            }
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp1");
            TestDistCpUtils.delete(fs, "/meta");
        }
    }

    private void createSrcAndWorkFilesWithDifferentChecksum(FileSystem fs, String targetBase, String sourceBase, String filename, int blocksPerChunk) throws IOException {
        long srcSeed = System.currentTimeMillis();
        long dstSeed = srcSeed + rand.nextLong();
        int bufferLen = 128;
        short replFactor = 2;
        Path srcData = new Path(sourceBase + filename);
        long firstChunkLength = 1024L * (long)blocksPerChunk;
        long secondChunkLength = 512L;
        DFSTestUtil.createFile((FileSystem)fs, (Path)srcData, (int)bufferLen, (long)firstChunkLength, (long)1024L, (short)replFactor, (long)srcSeed);
        DFSTestUtil.appendFileNewBlock((DistributedFileSystem)((DistributedFileSystem)fs), (Path)srcData, (int)((int)secondChunkLength));
        DFSTestUtil.createFile((FileSystem)fs, (Path)new Path(targetBase + filename + ".____distcpSplit____0." + firstChunkLength), (int)bufferLen, (long)firstChunkLength, (long)1024L, (short)replFactor, (long)dstSeed);
        DFSTestUtil.createFile((FileSystem)fs, (Path)new Path(targetBase + filename + ".____distcpSplit____" + firstChunkLength + "." + secondChunkLength), (int)bufferLen, (long)secondChunkLength, (long)1024L, (short)replFactor, (long)dstSeed);
    }

    private TaskAttemptContext getTaskAttemptContext(Configuration conf) {
        return new TaskAttemptContextImpl(conf, new TaskAttemptID("200707121733", 1, TaskType.MAP, 1, 1));
    }

    private void checkDirectoryPermissions(FileSystem fs, String targetBase, FsPermission sourcePerm) throws IOException {
        Path base = new Path(targetBase);
        Stack<Path> stack = new Stack<Path>();
        stack.push(base);
        while (!stack.isEmpty()) {
            FileStatus[] fStatus;
            Path file = (Path)stack.pop();
            if (!fs.exists(file) || (fStatus = fs.listStatus(file)) == null || fStatus.length == 0) continue;
            for (FileStatus status : fStatus) {
                if (!status.isDirectory()) continue;
                stack.push(status.getPath());
                Assert.assertEquals((Object)sourcePerm, (Object)status.getPermission());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDirectoryTimes(FileSystem fs, SequenceFile.Reader sourceReader, Path targetRoot) throws IOException {
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            while (sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                Path targetFile = new Path(targetRoot.toString() + "/" + srcRelPath);
                FileStatus targetStatus = fs.getFileStatus(targetFile);
                Assert.assertEquals((long)srcFileStatus.getModificationTime(), (long)targetStatus.getModificationTime());
                Assert.assertEquals((long)srcFileStatus.getAccessTime(), (long)targetStatus.getAccessTime());
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
        }
    }

    private static class NullInputFormat
    extends InputFormat {
        private NullInputFormat() {
        }

        public List getSplits(JobContext context) throws IOException, InterruptedException {
            return Collections.emptyList();
        }

        public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return null;
        }
    }
}

