/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetriableCommand {
    private static Logger LOG = LoggerFactory.getLogger(RetriableCommand.class);
    private static final long DELAY_MILLISECONDS = 500L;
    private static final int MAX_RETRIES = 3;
    private RetryPolicy retryPolicy = RetryPolicies.exponentialBackoffRetry((int)3, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    protected String description;

    public RetriableCommand(String description) {
        this.description = description;
    }

    public RetriableCommand(String description, RetryPolicy retryPolicy) {
        this(description);
        this.setRetryPolicy(retryPolicy);
    }

    protected abstract Object doExecute(Object ... var1) throws Exception;

    public Object execute(Object ... arguments) throws Exception {
        int counter = 0;
        while (true) {
            try {
                return this.doExecute(arguments);
            }
            catch (Exception exception) {
                LOG.error("Failure in Retriable command: " + this.description, (Throwable)exception);
                Exception latestException = exception;
                RetryPolicy.RetryAction action = this.retryPolicy.shouldRetry(latestException, ++counter, 0, true);
                if (action.action == RetryPolicy.RetryAction.RetryDecision.RETRY) {
                    ThreadUtil.sleepAtLeastIgnoreInterrupts((long)action.delayMillis);
                    continue;
                }
                throw new IOException("Couldn't run retriable-command: " + this.description, latestException);
            }
            break;
        }
    }

    public RetriableCommand setRetryPolicy(RetryPolicy retryHandler) {
        this.retryPolicy = retryHandler;
        return this;
    }
}

