/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapred.gridmix.RecordFactory;

class AvgRecordFactory
extends RecordFactory {
    public static final String GRIDMIX_KEY_FRC = "gridmix.key.fraction";
    public static final String GRIDMIX_MISSING_REC_SIZE = "gridmix.missing.rec.size";
    private final long targetBytes;
    private final long targetRecords;
    private final long step;
    private final int avgrec;
    private final int keyLen;
    private long accBytes = 0L;
    private long accRecords = 0L;
    private int unspilledBytes = 0;
    private int minSpilledBytes = 0;

    public AvgRecordFactory(long targetBytes, long targetRecords, Configuration conf) {
        this(targetBytes, targetRecords, conf, 0);
    }

    public AvgRecordFactory(long targetBytes, long targetRecords, Configuration conf, int minSpilledBytes) {
        this.targetBytes = targetBytes;
        this.targetRecords = targetRecords <= 0L && this.targetBytes >= 0L ? Math.max(1L, this.targetBytes / (long)conf.getInt(GRIDMIX_MISSING_REC_SIZE, 65536)) : targetRecords;
        long tmp = this.targetBytes / this.targetRecords;
        this.step = this.targetBytes - this.targetRecords * tmp;
        this.avgrec = (int)Math.min(Integer.MAX_VALUE, tmp + 1L);
        this.keyLen = Math.max(1, (int)((float)tmp * Math.min(1.0f, conf.getFloat(GRIDMIX_KEY_FRC, 0.1f))));
        this.minSpilledBytes = minSpilledBytes;
    }

    public boolean next(GridmixKey key, GridmixRecord val) throws IOException {
        if (this.accBytes >= this.targetBytes) {
            return false;
        }
        int reclen = this.accRecords++ >= this.step ? this.avgrec - 1 : this.avgrec;
        int len = (int)Math.min(this.targetBytes - this.accBytes, (long)reclen);
        this.unspilledBytes += len;
        if (key != null) {
            if (this.unspilledBytes < this.minSpilledBytes && this.accRecords < this.targetRecords) {
                key.setSize(1);
                val.setSize(1);
                this.accBytes += (long)(key.getSize() + val.getSize());
                this.unspilledBytes -= key.getSize() + val.getSize();
            } else {
                key.setSize(this.keyLen);
                val.setSize(this.unspilledBytes - key.getSize());
                this.accBytes += (long)this.unspilledBytes;
                this.unspilledBytes = 0;
            }
        } else if (this.unspilledBytes < this.minSpilledBytes && this.accRecords < this.targetRecords) {
            val.setSize(1);
            this.accBytes += (long)val.getSize();
            this.unspilledBytes -= val.getSize();
        } else {
            val.setSize(this.unspilledBytes);
            this.accBytes += (long)this.unspilledBytes;
            this.unspilledBytes = 0;
        }
        return true;
    }

    public float getProgress() throws IOException {
        return Math.min(1.0f, (float)this.accBytes / (float)this.targetBytes);
    }

    public void close() throws IOException {
    }
}

