/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.TestGridmixStatistics;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.tools.rumen.JobStory;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestGridmixStatistics {
    @Test
    public void testJobStats() throws Exception {
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        Statistics.JobStats stats = new Statistics.JobStats(1, 2, (Job)job);
        Assert.assertEquals((String)"Incorrect num-maps", (long)1L, (long)stats.getNoOfMaps());
        Assert.assertEquals((String)"Incorrect num-reds", (long)2L, (long)stats.getNoOfReds());
        Assert.assertTrue((String)"Incorrect job", (job == stats.getJob() ? 1 : 0) != 0);
        Assert.assertNull((String)"Unexpected job status", (Object)stats.getJobStatus());
        JobStatus status = new JobStatus();
        stats.updateJobStatus(status);
        Assert.assertNotNull((String)"Missing job status", (Object)stats.getJobStatus());
        Assert.assertTrue((String)"Incorrect job status", (status == stats.getJobStatus() ? 1 : 0) != 0);
    }

    private static JobStory getCustomJobStory(int numMaps, int numReds) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void testStatistics() throws Exception {
        Configuration conf = new Configuration();
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        Statistics.JobStats stats = Statistics.generateJobStats((Job)job, null);
        TestGridmixStatistics.testJobStats((Statistics.JobStats)stats, (int)-1, (int)-1, null, (Job)job);
        conf.setInt("gridmix.job.seq", 1);
        job = new /* Unavailable Anonymous Inner Class!! */;
        JobStory zjob = TestGridmixStatistics.getCustomJobStory((int)2, (int)1);
        stats = Statistics.generateJobStats((Job)job, (JobStory)zjob);
        TestGridmixStatistics.testJobStats((Statistics.JobStats)stats, (int)2, (int)1, null, (Job)job);
        JobStatus jStatus = new JobStatus();
        stats.updateJobStatus(jStatus);
        TestGridmixStatistics.testJobStats((Statistics.JobStats)stats, (int)2, (int)1, (JobStatus)jStatus, (Job)job);
        CountDownLatch startFlag = new CountDownLatch(1);
        Statistics statistics = new Statistics((Configuration)new JobConf(), 0, startFlag);
        statistics.start();
        TestGridmixStatistics.testClusterStats((int)0, (int)0, (int)0);
        statistics.addJobStats(stats);
        TestGridmixStatistics.testClusterStats((int)2, (int)1, (int)1);
        JobStory zjob2 = TestGridmixStatistics.getCustomJobStory((int)10, (int)5);
        conf.setInt("gridmix.job.seq", 2);
        job = new /* Unavailable Anonymous Inner Class!! */;
        Statistics.JobStats stats2 = Statistics.generateJobStats((Job)job, (JobStory)zjob2);
        statistics.addJobStats(stats2);
        TestGridmixStatistics.testClusterStats((int)12, (int)6, (int)2);
        statistics.add(stats2);
        TestGridmixStatistics.testClusterStats((int)2, (int)1, (int)1);
        statistics.add(stats);
        TestGridmixStatistics.testClusterStats((int)0, (int)0, (int)0);
        statistics.shutdown();
    }

    private static void testJobStats(Statistics.JobStats stats, int numMaps, int numReds, JobStatus jStatus, Job job) {
        Assert.assertEquals((String)"Incorrect num map tasks", (long)numMaps, (long)stats.getNoOfMaps());
        Assert.assertEquals((String)"Incorrect num reduce tasks", (long)numReds, (long)stats.getNoOfReds());
        if (job != null) {
            Assert.assertNotNull((String)"Missing job", (Object)job);
        }
        Assert.assertTrue((String)"Incorrect job", (job == stats.getJob() ? 1 : 0) != 0);
        if (jStatus != null) {
            Assert.assertNotNull((String)"Missing job status", (Object)jStatus);
        }
        Assert.assertTrue((String)"Incorrect job status", (jStatus == stats.getJobStatus() ? 1 : 0) != 0);
    }

    private static void testClusterStats(int numSubmittedMapTasks, int numSubmittedReduceTasks, int numSubmittedJobs) {
        Assert.assertEquals((String)"Incorrect count of total number of submitted map tasks", (long)numSubmittedMapTasks, (long)Statistics.ClusterStats.getSubmittedMapTasks());
        Assert.assertEquals((String)"Incorrect count of total number of submitted reduce tasks", (long)numSubmittedReduceTasks, (long)Statistics.ClusterStats.getSubmittedReduceTasks());
        Assert.assertEquals((String)"Incorrect submitted jobs", (long)numSubmittedJobs, (long)Statistics.ClusterStats.getRunningJobStats().size());
    }
}

