/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class BlockID {
    private ContainerBlockID containerBlockID;
    private long blockCommitSequenceId;

    public BlockID(long containerID, long localID) {
        this(containerID, localID, 0L);
    }

    private BlockID(long containerID, long localID, long bcsID) {
        this.containerBlockID = new ContainerBlockID(containerID, localID);
        this.blockCommitSequenceId = bcsID;
    }

    public BlockID(ContainerBlockID containerBlockID) {
        this(containerBlockID, 0L);
    }

    private BlockID(ContainerBlockID containerBlockID, long bcsId) {
        this.containerBlockID = containerBlockID;
        this.blockCommitSequenceId = bcsId;
    }

    public long getContainerID() {
        return this.containerBlockID.getContainerID();
    }

    public long getLocalID() {
        return this.containerBlockID.getLocalID();
    }

    public long getBlockCommitSequenceId() {
        return this.blockCommitSequenceId;
    }

    public void setBlockCommitSequenceId(long blockCommitSequenceId) {
        this.blockCommitSequenceId = blockCommitSequenceId;
    }

    public ContainerBlockID getContainerBlockID() {
        return this.containerBlockID;
    }

    public void setContainerBlockID(ContainerBlockID containerBlockID) {
        this.containerBlockID = containerBlockID;
    }

    public String toString() {
        return this.getContainerBlockID().toString() + " bcsId: " + this.blockCommitSequenceId;
    }

    public ContainerProtos.DatanodeBlockID getDatanodeBlockIDProtobuf() {
        return ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(this.containerBlockID.getContainerID()).setLocalID(this.containerBlockID.getLocalID()).setBlockCommitSequenceId(this.blockCommitSequenceId).build();
    }

    public static BlockID getFromProtobuf(ContainerProtos.DatanodeBlockID blockID) {
        return new BlockID(blockID.getContainerID(), blockID.getLocalID(), blockID.getBlockCommitSequenceId());
    }

    public HddsProtos.BlockID getProtobuf() {
        return HddsProtos.BlockID.newBuilder().setContainerBlockID(this.containerBlockID.getProtobuf()).setBlockCommitSequenceId(this.blockCommitSequenceId).build();
    }

    public static BlockID getFromProtobuf(HddsProtos.BlockID blockID) {
        return new BlockID(ContainerBlockID.getFromProtobuf(blockID.getContainerBlockID()), blockID.getBlockCommitSequenceId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockID blockID = (BlockID)o;
        return this.containerBlockID.equals(blockID.getContainerBlockID()) && this.blockCommitSequenceId == blockID.getBlockCommitSequenceId();
    }

    public int hashCode() {
        return Objects.hash(this.containerBlockID.getContainerID(), this.containerBlockID.getLocalID(), this.blockCommitSequenceId);
    }
}

