/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;

public class SCMSecurityProtocolServerSideTranslatorPB
implements SCMSecurityProtocolPB {
    private final SCMSecurityProtocol impl;

    public SCMSecurityProtocolServerSideTranslatorPB(SCMSecurityProtocol impl) {
        this.impl = impl;
    }

    @Override
    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificate(RpcController controller, SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto request) throws ServiceException {
        try {
            String certificate = this.impl.getDataNodeCertificate(request.getDatanodeDetails(), request.getCSR());
            SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertificate(RpcController controller, SCMSecurityProtocolProtos.SCMGetOMCertRequestProto request) throws ServiceException {
        try {
            String certificate = this.impl.getOMCertificate(request.getOmDetails(), request.getCSR());
            SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCertificate(RpcController controller, SCMSecurityProtocolProtos.SCMGetCertificateRequestProto request) throws ServiceException {
        try {
            String certificate = this.impl.getCertificate(request.getCertSerialId());
            SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCACertificate(RpcController controller, SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto request) throws ServiceException {
        try {
            String certificate = this.impl.getCACertificate();
            SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

