/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;

public abstract class XceiverClientSpi
implements Closeable {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private boolean isEvicted = false;

    XceiverClientSpi() {
    }

    void incrementReference() {
        this.referenceCount.incrementAndGet();
    }

    void decrementReference() {
        this.referenceCount.decrementAndGet();
        this.cleanup();
    }

    void setEvicted() {
        this.isEvicted = true;
        this.cleanup();
    }

    private void cleanup() {
        if (this.referenceCount.get() == 0 && this.isEvicted) {
            this.close();
        }
    }

    @VisibleForTesting
    public int getRefcount() {
        return this.referenceCount.get();
    }

    public abstract void connect() throws Exception;

    public abstract void connect(String var1) throws Exception;

    @Override
    public abstract void close();

    public abstract Pipeline getPipeline();

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        try {
            XceiverClientReply reply = this.sendCommandAsync(request);
            ContainerProtos.ContainerCommandResponseProto responseProto = reply.getResponse().get();
            return responseProto;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to command " + request, e);
        }
    }

    public XceiverClientReply sendCommand(ContainerProtos.ContainerCommandRequestProto request, List<DatanodeDetails> excludeDns) throws IOException {
        try {
            XceiverClientReply reply = this.sendCommandAsync(request);
            reply.getResponse().get();
            return reply;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to command " + request, e);
        }
    }

    public abstract XceiverClientReply sendCommandAsync(ContainerProtos.ContainerCommandRequestProto var1) throws IOException, ExecutionException, InterruptedException;

    public abstract HddsProtos.ReplicationType getPipelineType();

    public abstract XceiverClientReply watchForCommit(long var1, long var3) throws InterruptedException, ExecutionException, TimeoutException, IOException;

    public abstract long getReplicatedMinCommitIndex();
}

