/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.UnknownPipelineStateException;

public final class Pipeline {
    private final PipelineID id;
    private final HddsProtos.ReplicationType type;
    private final HddsProtos.ReplicationFactor factor;
    private PipelineState state;
    private Map<DatanodeDetails, Long> nodeStatus;

    private Pipeline(PipelineID id, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, PipelineState state, Map<DatanodeDetails, Long> nodeStatus) {
        this.id = id;
        this.type = type;
        this.factor = factor;
        this.state = state;
        this.nodeStatus = nodeStatus;
    }

    public PipelineID getId() {
        return this.id;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public PipelineState getPipelineState() {
        return this.state;
    }

    public List<DatanodeDetails> getNodes() {
        return new ArrayList<DatanodeDetails>(this.nodeStatus.keySet());
    }

    public DatanodeDetails getFirstNode() throws IOException {
        if (this.nodeStatus.isEmpty()) {
            throw new IOException(String.format("Pipeline=%s is empty", this.id));
        }
        return this.nodeStatus.keySet().iterator().next();
    }

    public boolean isClosed() {
        return this.state == PipelineState.CLOSED;
    }

    public boolean isOpen() {
        return this.state == PipelineState.OPEN;
    }

    void reportDatanode(DatanodeDetails dn) throws IOException {
        if (this.nodeStatus.get(dn) == null) {
            throw new IOException(String.format("Datanode=%s not part of pipeline=%s", dn, this.id));
        }
        this.nodeStatus.put(dn, System.currentTimeMillis());
    }

    boolean isHealthy() {
        for (Long reportedTime : this.nodeStatus.values()) {
            if (reportedTime >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.nodeStatus.isEmpty();
    }

    public HddsProtos.Pipeline getProtobufMessage() throws UnknownPipelineStateException {
        HddsProtos.Pipeline.Builder builder = HddsProtos.Pipeline.newBuilder().setId(this.id.getProtobuf()).setType(this.type).setFactor(this.factor).setState(PipelineState.getProtobuf(this.state)).setLeaderID("").addAllMembers(this.nodeStatus.keySet().stream().map(DatanodeDetails::getProtoBufMessage).collect(Collectors.toList()));
        return builder.build();
    }

    public static Pipeline getFromProtobuf(HddsProtos.Pipeline pipeline) throws UnknownPipelineStateException {
        Preconditions.checkNotNull((Object)pipeline, (Object)"Pipeline is null");
        return new Builder().setId(PipelineID.getFromProtobuf(pipeline.getId())).setFactor(pipeline.getFactor()).setType(pipeline.getType()).setState(PipelineState.fromProtobuf(pipeline.getState())).setNodes(pipeline.getMembersList().stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline that = (Pipeline)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.type, (Object)that.type).append((Object)this.factor, (Object)that.factor).append(this.getNodes(), that.getNodes()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.type).append((Object)this.factor).append(this.nodeStatus).toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("[");
        b.append(" Id: ").append(this.id.getId());
        b.append(", Nodes: ");
        this.nodeStatus.keySet().forEach(b::append);
        b.append(", Type:").append((Object)this.getType());
        b.append(", Factor:").append((Object)this.getFactor());
        b.append(", State:").append((Object)this.getPipelineState());
        b.append("]");
        return b.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Pipeline pipeline) {
        return new Builder(pipeline);
    }

    public static enum PipelineState {
        ALLOCATED,
        OPEN,
        CLOSED;


        public static PipelineState fromProtobuf(HddsProtos.PipelineState state) throws UnknownPipelineStateException {
            Preconditions.checkNotNull((Object)((Object)state), (Object)"Pipeline state is null");
            switch (state) {
                case PIPELINE_ALLOCATED: {
                    return ALLOCATED;
                }
                case PIPELINE_OPEN: {
                    return OPEN;
                }
                case PIPELINE_CLOSED: {
                    return CLOSED;
                }
            }
            throw new UnknownPipelineStateException("Pipeline state: " + (Object)((Object)state) + " is not recognized.");
        }

        public static HddsProtos.PipelineState getProtobuf(PipelineState state) throws UnknownPipelineStateException {
            Preconditions.checkNotNull((Object)((Object)state), (Object)"Pipeline state is null");
            switch (state) {
                case ALLOCATED: {
                    return HddsProtos.PipelineState.PIPELINE_ALLOCATED;
                }
                case OPEN: {
                    return HddsProtos.PipelineState.PIPELINE_OPEN;
                }
                case CLOSED: {
                    return HddsProtos.PipelineState.PIPELINE_CLOSED;
                }
            }
            throw new UnknownPipelineStateException("Pipeline state: " + (Object)((Object)state) + " is not recognized.");
        }
    }

    public static class Builder {
        private PipelineID id = null;
        private HddsProtos.ReplicationType type = null;
        private HddsProtos.ReplicationFactor factor = null;
        private PipelineState state = null;
        private Map<DatanodeDetails, Long> nodeStatus = null;

        public Builder() {
        }

        public Builder(Pipeline pipeline) {
            this.id = pipeline.id;
            this.type = pipeline.type;
            this.factor = pipeline.factor;
            this.state = pipeline.state;
            this.nodeStatus = pipeline.nodeStatus;
        }

        public Builder setId(PipelineID id1) {
            this.id = id1;
            return this;
        }

        public Builder setType(HddsProtos.ReplicationType type1) {
            this.type = type1;
            return this;
        }

        public Builder setFactor(HddsProtos.ReplicationFactor factor1) {
            this.factor = factor1;
            return this;
        }

        public Builder setState(PipelineState state1) {
            this.state = state1;
            return this;
        }

        public Builder setNodes(List<DatanodeDetails> nodes) {
            this.nodeStatus = new LinkedHashMap<DatanodeDetails, Long>();
            nodes.forEach(node -> this.nodeStatus.put((DatanodeDetails)node, -1L));
            return this;
        }

        public Pipeline build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)((Object)this.type));
            Preconditions.checkNotNull((Object)((Object)this.factor));
            Preconditions.checkNotNull((Object)((Object)this.state));
            Preconditions.checkNotNull(this.nodeStatus);
            return new Pipeline(this.id, this.type, this.factor, this.state, this.nodeStatus);
        }
    }
}

