/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;

@InterfaceAudience.Private
public final class ScmLocatedBlock {
    private final String key;
    private final List<DatanodeInfo> locations;
    private final DatanodeInfo leader;

    public ScmLocatedBlock(String key, List<DatanodeInfo> locations, DatanodeInfo leader) {
        this.key = key;
        this.locations = locations;
        this.leader = leader;
    }

    public String getKey() {
        return this.key;
    }

    public DatanodeInfo getLeader() {
        return this.leader;
    }

    public List<DatanodeInfo> getLocations() {
        return this.locations;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof ScmLocatedBlock)) {
            return false;
        }
        ScmLocatedBlock other = (ScmLocatedBlock)otherObj;
        return this.key == null ? other.key == null : this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{key=" + this.key + "; locations=" + this.locations.stream().map(loc -> loc.toString()).collect(Collectors.joining(",")) + "; leader=" + this.leader + "}";
    }
}

