/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;

@InterfaceAudience.Private
public final class ScmBlockLocationProtocolClientSideTranslatorPB
implements ScmBlockLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final ScmBlockLocationProtocolPB rpcProxy;

    public ScmBlockLocationProtocolClientSideTranslatorPB(ScmBlockLocationProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public List<AllocatedBlock> allocateBlock(long size, int num, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner, ExcludeList excludeList) throws IOException {
        ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto response;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"block size must be greater than 0");
        ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto request = ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto.newBuilder().setSize(size).setNumBlocks(num).setType(type).setFactor(factor).setOwner(owner).setTraceID(TracingUtil.exportCurrentSpan()).setExcludeList(excludeList.getProtoBuf()).build();
        try {
            response = this.rpcProxy.allocateScmBlock(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.transformServiceException(e);
        }
        if (response.getErrorCode() != ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Error.success) {
            throw new IOException(response.hasErrorMessage() ? response.getErrorMessage() : "Allocate block failed.");
        }
        ArrayList<AllocatedBlock> blocks = new ArrayList<AllocatedBlock>(response.getBlocksCount());
        for (ScmBlockLocationProtocolProtos.AllocateBlockResponse resp : response.getBlocksList()) {
            AllocatedBlock.Builder builder = new AllocatedBlock.Builder().setContainerBlockID(ContainerBlockID.getFromProtobuf(resp.getContainerBlockID())).setPipeline(Pipeline.getFromProtobuf(resp.getPipeline()));
            blocks.add(builder.build());
        }
        return blocks;
    }

    @Override
    public List<DeleteBlockGroupResult> deleteKeyBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto resp;
        List keyBlocksProto = keyBlocksInfoList.stream().map(BlockGroup::getProto).collect(Collectors.toList());
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto request = ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto.newBuilder().addAllKeyBlocks(keyBlocksProto).build();
        try {
            resp = this.rpcProxy.deleteScmKeyBlocks(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.transformServiceException(e);
        }
        ArrayList<DeleteBlockGroupResult> results = new ArrayList<DeleteBlockGroupResult>(resp.getResultsCount());
        results.addAll(resp.getResultsList().stream().map(result -> new DeleteBlockGroupResult(result.getObjectKey(), DeleteBlockGroupResult.convertBlockResultProto(result.getBlockResultsList()))).collect(Collectors.toList()));
        return results;
    }

    private IOException transformServiceException(ServiceException se) throws IOException {
        Throwable cause = se.getCause();
        if (cause == null) {
            return new IOException(new ServiceException(this.useFirstLine(se.getMessage()), se.getCause()));
        }
        return new IOException(this.useFirstLine(cause.getMessage()), cause.getCause());
    }

    private String useFirstLine(String message) {
        if (message == null) {
            return null;
        }
        return message.split("\n")[0];
    }

    @Override
    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRespsonseProto resp;
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.getDefaultInstance();
        try {
            resp = this.rpcProxy.getScmInfo(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.transformServiceException(e);
        }
        ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId());
        return builder.build();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

