/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.BlockNotCommittedException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerNotOpenException;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSelector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public final class ContainerProtocolCalls {
    private ContainerProtocolCalls() {
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, String traceID) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setGetBlock(readBlockRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(ContainerProtocolCalls.getService(datanodeBlockID));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getGetBlock();
    }

    public static ContainerProtos.GetCommittedBlockLengthResponseProto getCommittedBlockLength(XceiverClientSpi xceiverClient, BlockID blockID, String traceID) throws IOException {
        ContainerProtos.GetCommittedBlockLengthRequestProto.Builder getBlockLengthRequestBuilder = ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetCommittedBlockLength).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setGetCommittedBlockLength(getBlockLengthRequestBuilder);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(new Text(blockID.getContainerBlockID().toString()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getGetCommittedBlockLength();
    }

    public static ContainerProtos.PutBlockResponseProto putBlock(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, String traceID) throws IOException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(ContainerProtocolCalls.getService(containerBlockData.getBlockID()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getPutBlock();
    }

    public static XceiverClientReply putBlockAsync(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, String traceID) throws IOException, InterruptedException, ExecutionException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(ContainerProtocolCalls.getService(containerBlockData.getBlockID()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        return xceiverClient.sendCommandAsync(request);
    }

    public static XceiverClientReply readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, String traceID, List<DatanodeDetails> excludeDns) throws IOException {
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setReadChunk(readChunkRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(new Text(blockID.getContainerBlockID().toString()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        XceiverClientReply reply = xceiverClient.sendCommand(request, excludeDns);
        return reply;
    }

    public static void writeChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, String traceID) throws IOException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setData(data);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(new Text(blockID.getContainerBlockID().toString()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static XceiverClientReply writeChunkAsync(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, String traceID) throws IOException, ExecutionException, InterruptedException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setData(data);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(new Text(blockID.getContainerBlockID().toString()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.PutSmallFileResponseProto writeSmallFile(XceiverClientSpi client, BlockID blockID, byte[] data, String traceID) throws IOException {
        ContainerProtos.BlockData containerBlockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).build();
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("OverWriteRequested").setValue("true").build();
        Checksum checksum = new Checksum();
        ChecksumData checksumData = checksum.computeChecksum(data);
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk").setOffset(0L).setLen(data.length).addMetadata(keyValue).setChecksumData(checksumData.getProtoBufMessage()).build();
        ContainerProtos.PutSmallFileRequestProto putSmallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder().setChunkInfo(chunk).setBlock(createBlockRequest).setData(ByteString.copyFrom((byte[])data)).build();
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutSmallFile).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setPutSmallFile(putSmallFileRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(new Text(blockID.getContainerBlockID().toString()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getPutSmallFile();
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String traceID, String encodedToken) throws IOException {
        ContainerProtos.CreateContainerRequestProto.Builder createRequest = ContainerProtos.CreateContainerRequestProto.newBuilder();
        createRequest.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(createRequest.build());
        request.setDatanodeUuid(id);
        request.setTraceID(traceID);
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static void deleteContainer(XceiverClientSpi client, long containerID, boolean force, String traceID, String encodedToken) throws IOException {
        ContainerProtos.DeleteContainerRequestProto.Builder deleteRequest = ContainerProtos.DeleteContainerRequestProto.newBuilder();
        deleteRequest.setForceDelete(force);
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.DeleteContainer);
        request.setContainerID(containerID);
        request.setDeleteContainer(deleteRequest);
        request.setTraceID(traceID);
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static void closeContainer(XceiverClientSpi client, long containerID, String traceID, String encodedToken) throws IOException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CloseContainer);
        request.setContainerID(containerID);
        request.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        request.setTraceID(traceID);
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static ContainerProtos.ReadContainerResponseProto readContainer(XceiverClientSpi client, long containerID, String traceID, String encodedToken) throws IOException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        request.setTraceID(traceID);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getReadContainer();
    }

    public static ContainerProtos.GetSmallFileResponseProto readSmallFile(XceiverClientSpi client, BlockID blockID, String traceID) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder getBlock = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.GetSmallFileRequestProto getSmallFileRequest = ContainerProtos.GetSmallFileRequestProto.newBuilder().setBlock(getBlock).build();
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetSmallFile).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setGetSmallFile(getSmallFileRequest);
        String encodedToken = ContainerProtocolCalls.getEncodedBlockToken(new Text(blockID.getContainerBlockID().toString()));
        if (encodedToken != null) {
            builder.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getGetSmallFile();
    }

    public static void validateContainerResponse(ContainerProtos.ContainerCommandResponseProto response) throws StorageContainerException {
        if (response.getResult() == ContainerProtos.Result.SUCCESS) {
            return;
        }
        if (response.getResult() == ContainerProtos.Result.BLOCK_NOT_COMMITTED) {
            throw new BlockNotCommittedException(response.getMessage());
        }
        if (response.getResult() == ContainerProtos.Result.CLOSED_CONTAINER_IO) {
            throw new ContainerNotOpenException(response.getMessage());
        }
        throw new StorageContainerException(response.getMessage(), response.getResult());
    }

    private static String getEncodedBlockToken(Text service) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Token<OzoneBlockTokenIdentifier> token = OzoneBlockTokenSelector.selectBlockToken(service, ugi.getTokens());
        if (token != null) {
            return token.encodeToUrlString();
        }
        return null;
    }

    private static Text getService(ContainerProtos.DatanodeBlockID blockId) {
        return new Text(new StringBuffer().append("conID: ").append(blockId.getContainerID()).append(" locID: ").append(blockId.getLocalID()).toString());
    }
}

