/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.exceptions.EmptyTracerStateStringException;
import io.jaegertracing.internal.exceptions.MalformedTracerStateStringException;
import io.jaegertracing.internal.exceptions.TraceIdOutOfBoundException;
import io.jaegertracing.spi.Codec;
import io.opentracing.propagation.Format;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringCodec
implements Codec<StringBuilder> {
    public static final Logger LOG = LoggerFactory.getLogger(StringCodec.class);
    public static final StringFormat FORMAT = new StringFormat();

    public JaegerSpanContext extract(StringBuilder s) {
        if (s == null) {
            throw new EmptyTracerStateStringException();
        }
        String value = s.toString();
        if (value != null && !value.equals("")) {
            String[] parts = value.split(":");
            if (parts.length != 4) {
                LOG.trace("MalformedTracerStateString: {}", (Object)value);
                throw new MalformedTracerStateStringException(value);
            }
            String traceId = parts[0];
            if (traceId.length() <= 32 && traceId.length() >= 1) {
                return new JaegerSpanContext(StringCodec.high(traceId), new BigInteger(traceId, 16).longValue(), new BigInteger(parts[1], 16).longValue(), new BigInteger(parts[2], 16).longValue(), new BigInteger(parts[3], 16).byteValue());
            }
            throw new TraceIdOutOfBoundException("Trace id [" + traceId + "] length is not withing 1 and 32");
        }
        throw new EmptyTracerStateStringException();
    }

    public void inject(JaegerSpanContext context, StringBuilder string) {
        int intFlag = context.getFlags() & 0xFF;
        string.append(context.getTraceId() + ":" + Long.toHexString(context.getSpanId()) + ":" + Long.toHexString(context.getParentId()) + ":" + Integer.toHexString(intFlag));
    }

    private static long high(String hexString) {
        if (hexString.length() > 16) {
            int highLength = hexString.length() - 16;
            String highString = hexString.substring(0, highLength);
            return new BigInteger(highString, 16).longValue();
        }
        return 0L;
    }

    public static final class StringFormat
    implements Format<StringBuilder> {
    }
}

