/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.spi.Extractor;
import io.jaegertracing.spi.Injector;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hdds.tracing.StringCodec;
import org.apache.hadoop.hdds.tracing.TraceAllMethod;

public final class TracingUtil {
    private TracingUtil() {
    }

    public static void initTracing(String serviceName) {
        if (!GlobalTracer.isRegistered()) {
            Configuration config = Configuration.fromEnv((String)serviceName);
            JaegerTracer tracer = config.getTracerBuilder().registerExtractor((Format)StringCodec.FORMAT, (Extractor)new StringCodec()).registerInjector((Format)StringCodec.FORMAT, (Injector)new StringCodec()).build();
            GlobalTracer.register((Tracer)tracer);
        }
    }

    public static String exportCurrentSpan() {
        StringBuilder builder = new StringBuilder();
        if (GlobalTracer.get().activeSpan() != null) {
            GlobalTracer.get().inject(GlobalTracer.get().activeSpan().context(), (Format)StringCodec.FORMAT, (Object)builder);
        }
        return builder.toString();
    }

    public static Scope importAndCreateScope(String name, String encodedParent) {
        Tracer tracer = GlobalTracer.get();
        SpanContext parentSpan = null;
        if (encodedParent != null && encodedParent.length() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(encodedParent);
            parentSpan = tracer.extract((Format)StringCodec.FORMAT, (Object)builder);
        }
        Tracer.SpanBuilder spanBuilder = parentSpan == null ? tracer.buildSpan(name) : tracer.buildSpan(name).asChildOf(parentSpan);
        return spanBuilder.startActive(true);
    }

    public static <T> T createProxy(T delegate, Class<T> interfce) {
        Class<?> aClass = delegate.getClass();
        return (T)Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{interfce}, new TraceAllMethod<T>(delegate, interfce.getSimpleName()));
    }
}

