/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.util.Objects;

public class OzoneAcl {
    private OzoneACLType type;
    private String name;
    private OzoneACLRights rights;

    public OzoneAcl() {
    }

    public OzoneAcl(OzoneACLType type, String name, OzoneACLRights rights) {
        this.name = name;
        this.rights = rights;
        this.type = type;
        if (type == OzoneACLType.WORLD && name.length() != 0) {
            throw new IllegalArgumentException("Unexpected name part in world type");
        }
        if ((type == OzoneACLType.USER || type == OzoneACLType.GROUP) && name.length() == 0) {
            throw new IllegalArgumentException("User or group name is required");
        }
    }

    public static OzoneAcl parseAcl(String acl) throws IllegalArgumentException {
        if (acl == null || acl.isEmpty()) {
            throw new IllegalArgumentException("ACLs cannot be null or empty");
        }
        String[] parts = acl.trim().split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("ACLs are not in expected format");
        }
        OzoneACLType aclType = OzoneACLType.valueOf(parts[0].toUpperCase());
        OzoneACLRights rights = OzoneACLRights.getACLRight(parts[2].toLowerCase());
        return new OzoneAcl(aclType, parts[1], rights);
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + this.name + ":" + OzoneACLRights.getACLRightsString(this.rights);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getRights().toString(), this.getType().toString());
    }

    public String getName() {
        return this.name;
    }

    public OzoneACLRights getRights() {
        return this.rights;
    }

    public OzoneACLType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OzoneAcl otherAcl = (OzoneAcl)obj;
        return otherAcl.getName().equals(this.getName()) && otherAcl.getRights() == this.getRights() && otherAcl.getType() == this.getType();
    }

    public static enum OzoneACLRights {
        READ,
        WRITE,
        READ_WRITE;


        public static OzoneACLRights getACLRight(String type) {
            if (type == null || type.isEmpty()) {
                throw new IllegalArgumentException("ACL right cannot be empty");
            }
            switch (type) {
                case "r": {
                    return READ;
                }
                case "w": {
                    return WRITE;
                }
                case "rw": 
                case "wr": {
                    return READ_WRITE;
                }
            }
            throw new IllegalArgumentException("ACL right is not recognized");
        }

        public static String getACLRightsString(OzoneACLRights acl) {
            switch (acl) {
                case READ: {
                    return "r";
                }
                case WRITE: {
                    return "w";
                }
                case READ_WRITE: {
                    return "rw";
                }
            }
            throw new IllegalArgumentException("ACL right is not recognized");
        }
    }

    public static enum OzoneACLType {
        USER("user"),
        GROUP("group"),
        WORLD("world");

        private final String value;

        private OzoneACLType(String val) {
            this.value = val;
        }
    }
}

