/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import io.opentracing.Scope;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolServerSideTranslatorPB
implements StorageContainerLocationProtocolPB {
    private final StorageContainerLocationProtocol impl;

    public StorageContainerLocationProtocolServerSideTranslatorPB(StorageContainerLocationProtocol impl) throws IOException {
        this.impl = impl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.ContainerResponseProto allocateContainer(RpcController unused, StorageContainerLocationProtocolProtos.ContainerRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("allocateContainer", request.getTraceID());){
            ContainerWithPipeline containerWithPipeline = this.impl.allocateContainer(request.getReplicationType(), request.getReplicationFactor(), request.getOwner());
            StorageContainerLocationProtocolProtos.ContainerResponseProto containerResponseProto = StorageContainerLocationProtocolProtos.ContainerResponseProto.newBuilder().setContainerWithPipeline(containerWithPipeline.getProtobuf()).setErrorCode(StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success).build();
            return containerResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.GetContainerResponseProto getContainer(RpcController controller, StorageContainerLocationProtocolProtos.GetContainerRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("getContainer", request.getTraceID());){
            ContainerInfo container = this.impl.getContainer(request.getContainerID());
            StorageContainerLocationProtocolProtos.GetContainerResponseProto getContainerResponseProto = StorageContainerLocationProtocolProtos.GetContainerResponseProto.newBuilder().setContainerInfo(container.getProtobuf()).build();
            return getContainerResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto getContainerWithPipeline(RpcController controller, StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("getContainerWithPipeline", request.getTraceID());){
            ContainerWithPipeline container = this.impl.getContainerWithPipeline(request.getContainerID());
            StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto getContainerWithPipelineResponseProto = StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto.newBuilder().setContainerWithPipeline(container.getProtobuf()).build();
            return getContainerWithPipelineResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.SCMListContainerResponseProto listContainer(RpcController controller, StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("listContainer", request.getTraceID());){
            long startContainerID = 0L;
            int count = -1;
            if (request.hasStartContainerID()) {
                startContainerID = request.getStartContainerID();
            }
            count = request.getCount();
            List<ContainerInfo> containerList = this.impl.listContainer(startContainerID, count);
            StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.newBuilder();
            for (ContainerInfo container : containerList) {
                builder.addContainers(container.getProtobuf());
            }
            StorageContainerLocationProtocolProtos.SCMListContainerResponseProto sCMListContainerResponseProto = builder.build();
            return sCMListContainerResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto deleteContainer(RpcController controller, StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("deleteContainer", request.getTraceID());){
            this.impl.deleteContainer(request.getContainerID());
            StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto sCMDeleteContainerResponseProto = StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto.newBuilder().build();
            return sCMDeleteContainerResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.NodeQueryResponseProto queryNode(RpcController controller, StorageContainerLocationProtocolProtos.NodeQueryRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("queryNode", request.getTraceID());){
            HddsProtos.NodeState nodeState = request.getState();
            List<HddsProtos.Node> datanodes = this.impl.queryNode(nodeState, request.getScope(), request.getPoolName());
            StorageContainerLocationProtocolProtos.NodeQueryResponseProto nodeQueryResponseProto = StorageContainerLocationProtocolProtos.NodeQueryResponseProto.newBuilder().addAllDatanodes(datanodes).build();
            return nodeQueryResponseProto;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.ObjectStageChangeResponseProto notifyObjectStageChange(RpcController controller, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("notifyObjectStageChange", request.getTraceID());){
            this.impl.notifyObjectStageChange(request.getType(), request.getId(), request.getOp(), request.getStage());
            StorageContainerLocationProtocolProtos.ObjectStageChangeResponseProto objectStageChangeResponseProto = StorageContainerLocationProtocolProtos.ObjectStageChangeResponseProto.newBuilder().build();
            return objectStageChangeResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.PipelineResponseProto allocatePipeline(RpcController controller, StorageContainerLocationProtocolProtos.PipelineRequestProto request) throws ServiceException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.ListPipelineResponseProto listPipelines(RpcController controller, StorageContainerLocationProtocolProtos.ListPipelineRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("listPipelines", request.getTraceID());){
            StorageContainerLocationProtocolProtos.ListPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.ListPipelineResponseProto.newBuilder();
            List<Pipeline> pipelines = this.impl.listPipelines();
            for (Pipeline pipeline : pipelines) {
                HddsProtos.Pipeline protobufMessage = pipeline.getProtobufMessage();
                builder.addPipelines(protobufMessage);
            }
            StorageContainerLocationProtocolProtos.ListPipelineResponseProto listPipelineResponseProto = builder.build();
            return listPipelineResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.ClosePipelineResponseProto closePipeline(RpcController controller, StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("closePipeline", request.getTraceID());){
            this.impl.closePipeline(request.getPipelineID());
            StorageContainerLocationProtocolProtos.ClosePipelineResponseProto closePipelineResponseProto = StorageContainerLocationProtocolProtos.ClosePipelineResponseProto.newBuilder().build();
            return closePipelineResponseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HddsProtos.GetScmInfoRespsonseProto getScmInfo(RpcController controller, HddsProtos.GetScmInfoRequestProto req) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("getScmInfo", req.getTraceID());){
            ScmInfo scmInfo = this.impl.getScmInfo();
            HddsProtos.GetScmInfoRespsonseProto getScmInfoRespsonseProto = HddsProtos.GetScmInfoRespsonseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).build();
            return getScmInfoRespsonseProto;
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.InChillModeResponseProto inChillMode(RpcController controller, StorageContainerLocationProtocolProtos.InChillModeRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("inChillMode", request.getTraceID());){
            StorageContainerLocationProtocolProtos.InChillModeResponseProto inChillModeResponseProto = StorageContainerLocationProtocolProtos.InChillModeResponseProto.newBuilder().setInChillMode(this.impl.inChillMode()).build();
            return inChillModeResponseProto;
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StorageContainerLocationProtocolProtos.ForceExitChillModeResponseProto forceExitChillMode(RpcController controller, StorageContainerLocationProtocolProtos.ForceExitChillModeRequestProto request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope("forceExitChillMode", request.getTraceID());){
            StorageContainerLocationProtocolProtos.ForceExitChillModeResponseProto forceExitChillModeResponseProto = StorageContainerLocationProtocolProtos.ForceExitChillModeResponseProto.newBuilder().setExitedChillMode(this.impl.forceExitChillMode()).build();
            return forceExitChillModeResponseProto;
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }
}

