/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.utils.db.DBCheckpoint;
import org.rocksdb.Checkpoint;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBCheckpointManager {
    private final Checkpoint checkpoint;
    private final RocksDB db;
    public static final String RDB_CHECKPOINT_DIR_PREFIX = "rdb_checkpoint_";
    private static final Logger LOG = LoggerFactory.getLogger(RDBCheckpointManager.class);
    public static final String JAVA_TMP_DIR = "java.io.tmpdir";
    private String checkpointNamePrefix = "";

    public RDBCheckpointManager(RocksDB rocksDB) {
        this.db = rocksDB;
        this.checkpoint = Checkpoint.create((RocksDB)rocksDB);
    }

    public RDBCheckpointManager(RocksDB rocksDB, String checkpointPrefix) {
        this.db = rocksDB;
        this.checkpointNamePrefix = checkpointPrefix;
        this.checkpoint = Checkpoint.create((RocksDB)rocksDB);
    }

    public RocksDBCheckpoint createCheckpoint(String parentDir) {
        try {
            long currentTime = System.currentTimeMillis();
            String checkpointDir = "";
            if (StringUtils.isNotEmpty((CharSequence)this.checkpointNamePrefix)) {
                checkpointDir = checkpointDir + this.checkpointNamePrefix;
            }
            checkpointDir = checkpointDir + "_rdb_checkpoint_" + currentTime;
            Path checkpointPath = Paths.get(parentDir, checkpointDir);
            this.checkpoint.createCheckpoint(checkpointPath.toString());
            return new RocksDBCheckpoint(checkpointPath, currentTime, this.db.getLatestSequenceNumber());
        }
        catch (RocksDBException e) {
            LOG.error("Unable to create RocksDB Snapshot.", (Throwable)e);
            return null;
        }
    }

    static class RocksDBCheckpoint
    implements DBCheckpoint {
        private Path checkpointLocation;
        private long checkpointTimestamp;
        private long latestSequenceNumber;

        RocksDBCheckpoint(Path checkpointLocation, long snapshotTimestamp, long latestSequenceNumber) {
            this.checkpointLocation = checkpointLocation;
            this.checkpointTimestamp = snapshotTimestamp;
            this.latestSequenceNumber = latestSequenceNumber;
        }

        @Override
        public Path getCheckpointLocation() {
            return this.checkpointLocation;
        }

        @Override
        public long getCheckpointTimestamp() {
            return this.checkpointTimestamp;
        }

        @Override
        public long getLatestSequenceNumber() {
            return this.latestSequenceNumber;
        }

        @Override
        public void cleanupCheckpoint() throws IOException {
            FileUtils.deleteDirectory((File)this.checkpointLocation.toFile());
        }
    }
}

