/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.utils.RocksDBStoreMBean;
import org.apache.hadoop.utils.db.BatchOperation;
import org.apache.hadoop.utils.db.CodecRegistry;
import org.apache.hadoop.utils.db.DBCheckpoint;
import org.apache.hadoop.utils.db.DBStore;
import org.apache.hadoop.utils.db.RDBBatchOperation;
import org.apache.hadoop.utils.db.RDBCheckpointManager;
import org.apache.hadoop.utils.db.RDBTable;
import org.apache.hadoop.utils.db.Table;
import org.apache.hadoop.utils.db.TableConfig;
import org.apache.hadoop.utils.db.TypedTable;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBStore
implements DBStore {
    private static final Logger LOG = LoggerFactory.getLogger(RDBStore.class);
    private final RocksDB db;
    private final File dbLocation;
    private final WriteOptions writeOptions;
    private final DBOptions dbOptions;
    private final CodecRegistry codecRegistry;
    private final Hashtable<String, ColumnFamilyHandle> handleTable;
    private ObjectName statMBeanName;
    private RDBCheckpointManager checkPointManager;
    private final String checkpointsParentDir;

    @VisibleForTesting
    public RDBStore(File dbFile, DBOptions options, Set<TableConfig> families) throws IOException {
        this(dbFile, options, families, new CodecRegistry());
    }

    public RDBStore(File dbFile, DBOptions options, Set<TableConfig> families, CodecRegistry registry) throws IOException {
        Preconditions.checkNotNull((Object)dbFile, (Object)"DB file location cannot be null");
        Preconditions.checkNotNull(families);
        Preconditions.checkArgument((families.size() > 0 ? 1 : 0) != 0);
        this.handleTable = new Hashtable();
        this.codecRegistry = registry;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        ArrayList columnFamilyHandles = new ArrayList();
        for (TableConfig family : families) {
            columnFamilyDescriptors.add(family.getDescriptor());
        }
        this.dbOptions = options;
        this.dbLocation = dbFile;
        this.writeOptions = new WriteOptions();
        try {
            boolean success;
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.dbLocation.getAbsolutePath(), columnFamilyDescriptors, columnFamilyHandles);
            for (int x = 0; x < columnFamilyHandles.size(); ++x) {
                this.handleTable.put(DFSUtil.bytes2String((byte[])((ColumnFamilyHandle)columnFamilyHandles.get(x)).getName()), (ColumnFamilyHandle)columnFamilyHandles.get(x));
            }
            if (this.dbOptions.statistics() != null) {
                HashMap<String, String> jmxProperties = new HashMap<String, String>();
                jmxProperties.put("dbName", dbFile.getName());
                this.statMBeanName = HddsUtils.registerWithJmxProperties("Ozone", "RocksDbStore", jmxProperties, new RocksDBStoreMBean(this.dbOptions.statistics()));
                if (this.statMBeanName == null) {
                    LOG.warn("jmx registration failed during RocksDB init, db path :{}", (Object)dbFile.getAbsolutePath());
                }
            }
            this.checkpointsParentDir = Paths.get(this.dbLocation.getParent(), "om.db.checkpoints").toString();
            File checkpointsDir = new File(this.checkpointsParentDir);
            if (!checkpointsDir.exists() && !(success = checkpointsDir.mkdir())) {
                LOG.warn("Unable to create RocksDB checkpoint directory");
            }
            this.checkPointManager = new RDBCheckpointManager(this.db, "om");
        }
        catch (RocksDBException e) {
            throw RDBStore.toIOException("Failed init RocksDB, db path : " + dbFile.getAbsolutePath(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RocksDB successfully opened.");
            LOG.debug("[Option] dbLocation= {}", (Object)this.dbLocation.getAbsolutePath());
            LOG.debug("[Option] createIfMissing = {}", (Object)options.createIfMissing());
            LOG.debug("[Option] maxOpenFiles= {}", (Object)options.maxOpenFiles());
        }
    }

    public static IOException toIOException(String msg, RocksDBException e) {
        String statusCode = e.getStatus() == null ? "N/A" : e.getStatus().getCodeString();
        String errMessage = e.getMessage() == null ? "Unknown error" : e.getMessage();
        String output = msg + "; status : " + statusCode + "; message : " + errMessage;
        return new IOException(output, e);
    }

    @Override
    public void compactDB() throws IOException {
        if (this.db != null) {
            try {
                this.db.compactRange();
            }
            catch (RocksDBException e) {
                throw RDBStore.toIOException("Failed to compact db", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (ColumnFamilyHandle handle : this.handleTable.values()) {
            handle.close();
        }
        if (this.statMBeanName != null) {
            MBeans.unregister((ObjectName)this.statMBeanName);
            this.statMBeanName = null;
        }
        if (this.db != null) {
            this.db.close();
        }
        if (this.dbOptions != null) {
            this.dbOptions.close();
        }
        if (this.writeOptions != null) {
            this.writeOptions.close();
        }
    }

    @Override
    public <KEY, VALUE> void move(KEY key, Table<KEY, VALUE> source, Table<KEY, VALUE> dest) throws IOException {
        try (BatchOperation batchOperation = this.initBatchOperation();){
            VALUE value = source.get(key);
            dest.putWithBatch(batchOperation, key, value);
            source.deleteWithBatch(batchOperation, key);
            this.commitBatchOperation(batchOperation);
        }
    }

    @Override
    public <KEY, VALUE> void move(KEY key, VALUE value, Table<KEY, VALUE> source, Table<KEY, VALUE> dest) throws IOException {
        this.move(key, key, value, source, dest);
    }

    @Override
    public <KEY, VALUE> void move(KEY sourceKey, KEY destKey, VALUE value, Table<KEY, VALUE> source, Table<KEY, VALUE> dest) throws IOException {
        try (BatchOperation batchOperation = this.initBatchOperation();){
            dest.putWithBatch(batchOperation, destKey, value);
            source.deleteWithBatch(batchOperation, sourceKey);
            this.commitBatchOperation(batchOperation);
        }
    }

    @Override
    public long getEstimatedKeyCount() throws IOException {
        try {
            return this.db.getLongProperty("rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            throw RDBStore.toIOException("Unable to get the estimated count.", e);
        }
    }

    @Override
    public BatchOperation initBatchOperation() {
        return new RDBBatchOperation();
    }

    @Override
    public void commitBatchOperation(BatchOperation operation) throws IOException {
        ((RDBBatchOperation)operation).commit(this.db, this.writeOptions);
    }

    @VisibleForTesting
    protected ObjectName getStatMBeanName() {
        return this.statMBeanName;
    }

    @Override
    public Table<byte[], byte[]> getTable(String name) throws IOException {
        ColumnFamilyHandle handle = this.handleTable.get(name);
        if (handle == null) {
            throw new IOException("No such table in this DB. TableName : " + name);
        }
        return new RDBTable(this.db, handle, this.writeOptions);
    }

    @Override
    public <KEY, VALUE> Table<KEY, VALUE> getTable(String name, Class<KEY> keyType, Class<VALUE> valueType) throws IOException {
        return new TypedTable<KEY, VALUE>(this.getTable(name), this.codecRegistry, keyType, valueType);
    }

    @Override
    public ArrayList<Table> listTables() throws IOException {
        ArrayList<Table> returnList = new ArrayList<Table>();
        for (ColumnFamilyHandle handle : this.handleTable.values()) {
            returnList.add(new RDBTable(this.db, handle, this.writeOptions));
        }
        return returnList;
    }

    @Override
    public DBCheckpoint getCheckpoint(boolean flush) {
        FlushOptions flushOptions = new FlushOptions().setWaitForFlush(flush);
        try {
            this.db.flush(flushOptions);
        }
        catch (RocksDBException e) {
            LOG.error("Unable to Flush RocksDB data before creating snapshot", (Throwable)e);
        }
        return this.checkPointManager.createCheckpoint(this.checkpointsParentDir);
    }
}

