/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import java.io.IOException;
import org.apache.hadoop.utils.db.BatchOperation;
import org.apache.hadoop.utils.db.CodecRegistry;
import org.apache.hadoop.utils.db.Table;
import org.apache.hadoop.utils.db.TableIterator;

public class TypedTable<KEY, VALUE>
implements Table<KEY, VALUE> {
    private Table<byte[], byte[]> rawTable;
    private CodecRegistry codecRegistry;
    private Class<KEY> keyType;
    private Class<VALUE> valueType;

    public TypedTable(Table<byte[], byte[]> rawTable, CodecRegistry codecRegistry, Class<KEY> keyType, Class<VALUE> valueType) {
        this.rawTable = rawTable;
        this.codecRegistry = codecRegistry;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public void put(KEY key, VALUE value) throws IOException {
        byte[] keyData = this.codecRegistry.asRawData(key);
        byte[] valueData = this.codecRegistry.asRawData(value);
        this.rawTable.put(keyData, valueData);
    }

    @Override
    public void putWithBatch(BatchOperation batch, KEY key, VALUE value) throws IOException {
        byte[] keyData = this.codecRegistry.asRawData(key);
        byte[] valueData = this.codecRegistry.asRawData(value);
        this.rawTable.putWithBatch(batch, keyData, valueData);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.rawTable.isEmpty();
    }

    @Override
    public VALUE get(KEY key) throws IOException {
        byte[] keyBytes = this.codecRegistry.asRawData(key);
        byte[] valueBytes = this.rawTable.get(keyBytes);
        return this.codecRegistry.asObject(valueBytes, this.valueType);
    }

    @Override
    public void delete(KEY key) throws IOException {
        this.rawTable.delete(this.codecRegistry.asRawData(key));
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, KEY key) throws IOException {
        this.rawTable.deleteWithBatch(batch, this.codecRegistry.asRawData(key));
    }

    @Override
    public TableIterator<KEY, TypedKeyValue> iterator() {
        TableIterator<byte[], Table.KeyValue<byte[], byte[]>> iterator = this.rawTable.iterator();
        return new TypedTableIterator(iterator, this.keyType, this.valueType);
    }

    @Override
    public String getName() throws IOException {
        return this.rawTable.getName();
    }

    @Override
    public void close() throws Exception {
        this.rawTable.close();
    }

    public class TypedTableIterator
    implements TableIterator<KEY, TypedKeyValue> {
        private TableIterator<byte[], ? extends Table.KeyValue<byte[], byte[]>> rawIterator;
        private final Class<KEY> keyClass;
        private final Class<VALUE> valueClass;

        public TypedTableIterator(TableIterator<byte[], ? extends Table.KeyValue<byte[], byte[]>> rawIterator, Class<KEY> keyType, Class<VALUE> valueType) {
            this.rawIterator = rawIterator;
            this.keyClass = keyType;
            this.valueClass = valueType;
        }

        @Override
        public void seekToFirst() {
            this.rawIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.rawIterator.seekToLast();
        }

        @Override
        public TypedKeyValue seek(KEY key) throws IOException {
            byte[] keyBytes = TypedTable.this.codecRegistry.asRawData(key);
            Table.KeyValue<byte[], byte[]> result = this.rawIterator.seek(keyBytes);
            if (result == null) {
                return null;
            }
            return new TypedKeyValue(result);
        }

        @Override
        public KEY key() throws IOException {
            byte[] result = this.rawIterator.key();
            if (result == null) {
                return null;
            }
            return TypedTable.this.codecRegistry.asObject(result, this.keyClass);
        }

        @Override
        public TypedKeyValue value() {
            Table.KeyValue<byte[], byte[]> keyValue = this.rawIterator.value();
            if (keyValue != null) {
                return new TypedKeyValue(keyValue, this.keyClass, this.valueClass);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.rawIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public TypedKeyValue next() {
            return new TypedKeyValue((Table.KeyValue)this.rawIterator.next(), TypedTable.this.keyType, TypedTable.this.valueType);
        }
    }

    public class TypedKeyValue
    implements Table.KeyValue<KEY, VALUE> {
        private Table.KeyValue<byte[], byte[]> rawKeyValue;

        public TypedKeyValue(Table.KeyValue<byte[], byte[]> rawKeyValue) {
            this.rawKeyValue = rawKeyValue;
        }

        public TypedKeyValue(Table.KeyValue<byte[], byte[]> rawKeyValue, Class<KEY> keyType, Class<VALUE> valueType) {
            this.rawKeyValue = rawKeyValue;
        }

        @Override
        public KEY getKey() throws IOException {
            return TypedTable.this.codecRegistry.asObject(this.rawKeyValue.getKey(), TypedTable.this.keyType);
        }

        @Override
        public VALUE getValue() throws IOException {
            return TypedTable.this.codecRegistry.asObject(this.rawKeyValue.getValue(), TypedTable.this.valueType);
        }
    }
}

