/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RatisHelper {
    public static final Logger LOG = LoggerFactory.getLogger(RatisHelper.class);
    public static final RaftGroupId DUMMY_GROUP_ID = RaftGroupId.valueOf((ByteString)ByteString.copyFromUtf8((String)"AOzoneRatisGroup"));
    public static final RaftGroup EMPTY_GROUP = RaftGroup.valueOf((RaftGroupId)DUMMY_GROUP_ID, Collections.emptyList());

    public static String toRaftPeerIdString(DatanodeDetails id) {
        return id.getUuidString();
    }

    public static UUID toDatanodeId(String peerIdString) {
        return UUID.fromString(peerIdString);
    }

    public static UUID toDatanodeId(RaftPeerId peerId) {
        return RatisHelper.toDatanodeId(peerId.toString());
    }

    public static UUID toDatanodeId(RaftProtos.RaftPeerProto peerId) {
        return RatisHelper.toDatanodeId(RaftPeerId.valueOf((ByteString)peerId.getId()));
    }

    public static String toRaftPeerAddressString(DatanodeDetails id) {
        return id.getIpAddress() + ":" + id.getPort(DatanodeDetails.Port.Name.RATIS).getValue();
    }

    public static RaftPeerId toRaftPeerId(DatanodeDetails id) {
        return RaftPeerId.valueOf((String)RatisHelper.toRaftPeerIdString(id));
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id) {
        return new RaftPeer(RatisHelper.toRaftPeerId(id), RatisHelper.toRaftPeerAddressString(id));
    }

    public static List<RaftPeer> toRaftPeers(Pipeline pipeline) {
        return RatisHelper.toRaftPeers(pipeline.getNodes());
    }

    public static <E extends DatanodeDetails> List<RaftPeer> toRaftPeers(List<E> datanodes) {
        return datanodes.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
    }

    public static RaftGroup emptyRaftGroup() {
        return EMPTY_GROUP;
    }

    public static RaftGroup newRaftGroup(Collection<RaftPeer> peers) {
        return peers.isEmpty() ? RatisHelper.emptyRaftGroup() : RaftGroup.valueOf((RaftGroupId)DUMMY_GROUP_ID, peers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, Collection<DatanodeDetails> peers) {
        List newPeers = peers.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
        return peers.isEmpty() ? RaftGroup.valueOf((RaftGroupId)groupId, Collections.emptyList()) : RaftGroup.valueOf((RaftGroupId)groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(Pipeline pipeline) {
        return RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((UUID)pipeline.getId().getId()), RatisHelper.toRaftPeers(pipeline));
    }

    public static RaftClient newRaftClient(RpcType rpcType, Pipeline pipeline, RetryPolicy retryPolicy, int maxOutStandingRequest, GrpcTlsConfig tlsConfig, TimeDuration timeout) throws IOException {
        return RatisHelper.newRaftClient(rpcType, RatisHelper.toRaftPeerId(pipeline.getFirstNode()), RatisHelper.newRaftGroup(RaftGroupId.valueOf((UUID)pipeline.getId().getId()), pipeline.getNodes()), retryPolicy, maxOutStandingRequest, tlsConfig, timeout);
    }

    public static TimeDuration getClientRequestTimeout(Configuration conf) {
        TimeUnit timeUnit = OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = conf.getTimeDuration("dfs.ratis.client.request.timeout.duration", OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration clientRequestTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        return clientRequestTimeout;
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, int maxOutstandingRequests, GrpcTlsConfig tlsConfig, TimeDuration clientRequestTimeout) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(new ArrayList<RaftPeer>(Arrays.asList(leader))), retryPolicy, maxOutstandingRequests, tlsConfig, clientRequestTimeout);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, int maxOutstandingRequests, TimeDuration clientRequestTimeout) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(new ArrayList<RaftPeer>(Arrays.asList(leader))), retryPolicy, maxOutstandingRequests, null, clientRequestTimeout);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeerId leader, RaftGroup group, RetryPolicy retryPolicy, int maxOutStandingRequest, GrpcTlsConfig tlsConfig, TimeDuration clientRequestTimeout) {
        LOG.trace("newRaftClient: {}, leader={}, group={}", new Object[]{rpcType, leader, group});
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpcType);
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)clientRequestTimeout);
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)0x2000000L));
        GrpcConfigKeys.OutputStream.setOutstandingAppendsMax((RaftProperties)properties, (int)maxOutStandingRequest);
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leader).setProperties(properties).setRetryPolicy(retryPolicy);
        if (tlsConfig != null && rpcType == SupportedRpcType.GRPC) {
            builder.setParameters(GrpcFactory.newRaftParameters((GrpcTlsConfig)tlsConfig));
        }
        return builder.build();
    }

    public static GrpcTlsConfig createTlsClientConfig(SecurityConfig conf) {
        if (conf.isGrpcTlsEnabled()) {
            if (conf.isGrpcMutualTlsRequired()) {
                return new GrpcTlsConfig(null, null, conf.getTrustStoreFile(), false);
            }
            return new GrpcTlsConfig(conf.getClientPrivateKeyFile(), conf.getClientCertChainFile(), conf.getTrustStoreFile(), true);
        }
        return null;
    }

    public static GrpcTlsConfig createTlsServerConfig(SecurityConfig conf) {
        if (conf.isGrpcTlsEnabled()) {
            if (conf.isGrpcMutualTlsRequired()) {
                return new GrpcTlsConfig(conf.getServerPrivateKeyFile(), conf.getServerCertChainFile(), null, false);
            }
            return new GrpcTlsConfig(conf.getServerPrivateKeyFile(), conf.getServerCertChainFile(), conf.getClientCertChainFile(), true);
        }
        return null;
    }

    public static RetryPolicy createRetryPolicy(Configuration conf) {
        int maxRetryCount = conf.getInt("dfs.ratis.client.request.max.retries", 20);
        long retryInterval = conf.getTimeDuration("dfs.ratis.client.request.retry.interval", (long)OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_RETRY_INTERVAL_DEFAULT.toIntExact(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        TimeDuration sleepDuration = TimeDuration.valueOf((long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
        RetryPolicies.RetryLimited retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetryCount, (TimeDuration)sleepDuration);
        return retryPolicy;
    }
}

