/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class HddsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HddsUtils.class);
    public static final String OZONE_SCM_SERVICE_ID = "OzoneScmService";
    public static final String OZONE_SCM_SERVICE_INSTANCE_ID = "OzoneScmServiceInstance";
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final int NO_PORT = -1;

    private HddsUtils() {
    }

    public static InetSocketAddress getScmAddressForClients(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address");
        if (!host.isPresent()) {
            Collection<InetSocketAddress> scmAddresses = HddsUtils.getSCMAddresses(conf);
            if (scmAddresses.size() > 1) {
                throw new IllegalArgumentException("ozone.scm.names must contain a single hostname. Multiple SCM hosts are currently unsupported");
            }
            host = Optional.of(scmAddresses.iterator().next().getHostName());
        }
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Optional<Integer> port = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.client.address");
        return NetUtils.createSocketAddr((String)(host.get() + ":" + port.orElse(9860)));
    }

    public static InetSocketAddress getScmAddressForBlockClients(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.block.client.address");
        if (!host.isPresent()) {
            host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address");
        }
        if (!host.isPresent()) {
            Collection<InetSocketAddress> scmAddresses = HddsUtils.getSCMAddresses(conf);
            if (scmAddresses.size() > 1) {
                throw new IllegalArgumentException("ozone.scm.names must contain a single hostname. Multiple SCM hosts are currently unsupported");
            }
            host = Optional.of(scmAddresses.iterator().next().getHostName());
        }
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.scm.block.client.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Optional<Integer> port = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.block.client.address");
        return NetUtils.createSocketAddr((String)(host.get() + ":" + port.orElse(9863)));
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClient(OzoneConfiguration conf, InetSocketAddress address) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, SCMSecurityProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = new SCMSecurityProtocolClientSideTranslatorPB((SCMSecurityProtocolPB)RPC.getProxy(SCMSecurityProtocolPB.class, (long)scmVersion, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        return scmSecurityClient;
    }

    public static Optional<String> getHostNameFromConfigKeys(Configuration conf, String ... keys) {
        for (String key : keys) {
            String value = conf.getTrimmed(key);
            Optional<String> hostName = HddsUtils.getHostName(value);
            if (!hostName.isPresent()) continue;
            return hostName;
        }
        return Optional.empty();
    }

    public static Optional<String> getHostName(String value) {
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        String hostname = value.replaceAll("\\:[0-9]+$", "");
        if (hostname.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(hostname);
    }

    public static Optional<Integer> getHostPort(String value) {
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        int port = HostAndPort.fromString((String)value).getPortOrDefault(-1);
        if (port == -1) {
            return Optional.empty();
        }
        return Optional.of(port);
    }

    public static Optional<Integer> getPortNumberFromConfigKeys(Configuration conf, String ... keys) {
        for (String key : keys) {
            String value = conf.getTrimmed(key);
            Optional<Integer> hostPort = HddsUtils.getHostPort(value);
            if (!hostPort.isPresent()) continue;
            return hostPort;
        }
        return Optional.empty();
    }

    public static Collection<InetSocketAddress> getSCMAddresses(Configuration conf) throws IllegalArgumentException {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        Collection names = conf.getTrimmedStringCollection("ozone.scm.names");
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("ozone.scm.names need to be a set of valid DNS names or IP addresses. Null or empty address list found.");
        }
        Optional<Integer> defaultPort = Optional.of(9861);
        for (String address : names) {
            Optional<String> hostname = HddsUtils.getHostName(address);
            if (!hostname.isPresent()) {
                throw new IllegalArgumentException("Invalid hostname for SCM: " + hostname);
            }
            Optional<Integer> port = HddsUtils.getHostPort(address);
            InetSocketAddress addr = NetUtils.createSocketAddr((String)hostname.get(), (int)port.orElse(defaultPort.get()));
            addresses.add(addr);
        }
        return addresses;
    }

    public static boolean isHddsEnabled(Configuration conf) {
        return conf.getBoolean("ozone.enabled", false);
    }

    public static String getHostName(Configuration conf) throws UnknownHostException {
        String name = conf.get("dfs.datanode.hostname");
        if (name == null) {
            String dnsInterface = conf.get("hadoop.security.dns.interface");
            String nameServer = conf.get("hadoop.security.dns.nameserver");
            boolean fallbackToHosts = false;
            if (dnsInterface == null) {
                dnsInterface = conf.get("dfs.datanode.dns.interface");
                nameServer = conf.get("dfs.datanode.dns.nameserver");
            } else {
                fallbackToHosts = true;
            }
            name = DNS.getDefaultHost((String)dnsInterface, (String)nameServer, (boolean)fallbackToHosts);
        }
        return name;
    }

    public static boolean isReadOnly(ContainerProtos.ContainerCommandRequestProto proto) {
        switch (proto.getCmdType()) {
            case ReadContainer: 
            case ReadChunk: 
            case ListBlock: 
            case GetBlock: 
            case GetSmallFile: 
            case ListContainer: 
            case ListChunk: 
            case GetCommittedBlockLength: {
                return true;
            }
        }
        return false;
    }

    public static ObjectName registerWithJmxProperties(String serviceName, String mBeanName, Map<String, String> jmxProperties, Object mBean) {
        try {
            Method registerMethod = MBeans.class.getMethod("register", String.class, String.class, Map.class, Object.class);
            return (ObjectName)registerMethod.invoke(null, serviceName, mBeanName, jmxProperties, mBean);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.trace("Registering MBean {} without additional properties {}", (Object)mBeanName, jmxProperties);
            return MBeans.register((String)serviceName, (String)mBeanName, (Object)mBean);
        }
    }

    public static long getUtcTime() {
        return Calendar.getInstance(UTC_ZONE).getTimeInMillis();
    }

    public static InetSocketAddress getScmAddressForSecurityProtocol(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.security.service.address");
        if (!host.isPresent()) {
            host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address");
        }
        if (!host.isPresent()) {
            Collection<InetSocketAddress> scmAddresses = HddsUtils.getSCMAddresses(conf);
            if (scmAddresses.size() > 1) {
                throw new IllegalArgumentException("ozone.scm.names must contain a single hostname. Multiple SCM hosts are currently unsupported");
            }
            host = Optional.of(scmAddresses.iterator().next().getHostName());
        }
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.scm.security.service.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Optional<Integer> port = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.security.service.port");
        return NetUtils.createSocketAddr((String)(host.get() + ":" + port.orElse(9961)));
    }

    public static MetricsSystem initializeMetrics(OzoneConfiguration configuration, String serverName) {
        MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)serverName);
        JvmMetrics.create((String)serverName, (String)configuration.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        return metricsSystem;
    }
}

