/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

public class OzoneQuota {
    public static final String OZONE_QUOTA_BYTES = "BYTES";
    public static final String OZONE_QUOTA_MB = "MB";
    public static final String OZONE_QUOTA_GB = "GB";
    public static final String OZONE_QUOTA_TB = "TB";
    private Units unit;
    private long size;

    public long getSize() {
        return this.size;
    }

    public Units getUnit() {
        return this.unit;
    }

    public OzoneQuota() {
        this.size = 0L;
        this.unit = Units.UNDEFINED;
    }

    public OzoneQuota(long size, Units unit) {
        this.size = size;
        this.unit = unit;
    }

    public static String formatQuota(OzoneQuota quota) {
        return String.valueOf(quota.size) + (Object)((Object)quota.unit);
    }

    public static OzoneQuota parseQuota(String quotaString) throws IllegalArgumentException {
        if (quotaString == null || quotaString.isEmpty()) {
            throw new IllegalArgumentException("Quota string cannot be null or empty.");
        }
        String uppercase = quotaString.toUpperCase().replaceAll("\\s+", "");
        String size = "";
        Units currUnit = Units.MB;
        Boolean found = false;
        if (uppercase.endsWith(OZONE_QUOTA_MB)) {
            size = uppercase.substring(0, uppercase.length() - OZONE_QUOTA_MB.length());
            currUnit = Units.MB;
            found = true;
        }
        if (uppercase.endsWith(OZONE_QUOTA_GB)) {
            size = uppercase.substring(0, uppercase.length() - OZONE_QUOTA_GB.length());
            currUnit = Units.GB;
            found = true;
        }
        if (uppercase.endsWith(OZONE_QUOTA_TB)) {
            size = uppercase.substring(0, uppercase.length() - OZONE_QUOTA_TB.length());
            currUnit = Units.TB;
            found = true;
        }
        if (uppercase.endsWith(OZONE_QUOTA_BYTES)) {
            size = uppercase.substring(0, uppercase.length() - OZONE_QUOTA_BYTES.length());
            currUnit = Units.BYTES;
            found = true;
        }
        if (!found.booleanValue()) {
            throw new IllegalArgumentException("Quota unit not recognized. Supported values are BYTES, MB, GB and TB.");
        }
        int nSize = Integer.parseInt(size);
        if (nSize < 0) {
            throw new IllegalArgumentException("Quota cannot be negative.");
        }
        return new OzoneQuota(nSize, currUnit);
    }

    public long sizeInBytes() {
        switch (this.unit) {
            case BYTES: {
                return this.getSize();
            }
            case MB: {
                return this.getSize() * 0x100000L;
            }
            case GB: {
                return this.getSize() * 0x40000000L;
            }
            case TB: {
                return this.getSize() * 0x10000000000L;
            }
        }
        return -1L;
    }

    public static OzoneQuota getOzoneQuota(long sizeInBytes) {
        Units unit;
        long size;
        if (sizeInBytes % 0x10000000000L == 0L) {
            size = sizeInBytes / 0x10000000000L;
            unit = Units.TB;
        } else if (sizeInBytes % 0x40000000L == 0L) {
            size = sizeInBytes / 0x40000000L;
            unit = Units.GB;
        } else if (sizeInBytes % 0x100000L == 0L) {
            size = sizeInBytes / 0x100000L;
            unit = Units.MB;
        } else {
            size = sizeInBytes;
            unit = Units.BYTES;
        }
        return new OzoneQuota((int)size, unit);
    }

    public String toString() {
        return this.size + " " + (Object)((Object)this.unit);
    }

    public static enum Units {
        UNDEFINED,
        BYTES,
        KB,
        MB,
        GB,
        TB;

    }
}

