/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);

    private NetUtils() {
    }

    public static String normalize(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Network Location path does not start with /: " + path);
        }
        return path.length() == 1 ? path : path.replaceAll("/+$", "");
    }

    public static int locationToDepth(String location) {
        String newLocation = NetUtils.normalize(location);
        return newLocation.equals("/") ? 1 : newLocation.split("/").length;
    }

    public static String removeDuplicate(NetworkTopology topology, Collection<Node> mutableExcludedNodes, String excludedScope, int ancestorGen) {
        if (mutableExcludedNodes == null || mutableExcludedNodes.size() == 0 || excludedScope == null || topology == null) {
            return excludedScope;
        }
        Iterator<Node> iterator = mutableExcludedNodes.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Node ancestor = topology.getAncestor(node, ancestorGen);
            if (ancestor == null) {
                LOG.warn("Fail to get ancestor generation " + ancestorGen + " of node :" + node);
                continue;
            }
            if (excludedScope.startsWith(ancestor.getNetworkFullPath())) {
                return null;
            }
            if (!ancestor.getNetworkFullPath().startsWith(excludedScope)) continue;
            iterator.remove();
        }
        return excludedScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOutscope(Collection<Node> mutableExcludedNodes, String scope) {
        if (mutableExcludedNodes == null || scope == null) {
            return;
        }
        Collection<Node> collection = mutableExcludedNodes;
        synchronized (collection) {
            Iterator<Node> iterator = mutableExcludedNodes.iterator();
            while (iterator.hasNext()) {
                Node next = iterator.next();
                if (next.getNetworkFullPath().startsWith(scope)) continue;
                iterator.remove();
            }
        }
    }

    public static List<Node> getAncestorList(NetworkTopology topology, Collection<Node> nodes, int generation) {
        ArrayList<Node> ancestorList = new ArrayList<Node>();
        if (topology == null || nodes == null || nodes.size() == 0 || generation == 0) {
            return ancestorList;
        }
        for (Node node : nodes) {
            Node ancestor = topology.getAncestor(node, generation);
            if (ancestor == null) {
                LOG.warn("Fail to get ancestor generation " + generation + " of node :" + node);
                continue;
            }
            if (ancestorList.contains(ancestor)) continue;
            ancestorList.add(ancestor);
        }
        return ancestorList;
    }
}

