/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.InnerNodeImpl;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyImpl
implements NetworkTopology {
    public static final Logger LOG = LoggerFactory.getLogger(NetworkTopology.class);
    private final InnerNode.Factory factory;
    private final InnerNode clusterTree;
    private final int maxLevel;
    private final NodeSchemaManager schemaManager;
    private ReadWriteLock netlock = new ReentrantReadWriteLock(true);

    public NetworkTopologyImpl(Configuration conf) {
        this.schemaManager = NodeSchemaManager.getInstance();
        this.schemaManager.init(conf);
        this.maxLevel = this.schemaManager.getMaxLevel();
        this.factory = InnerNodeImpl.FACTORY;
        this.clusterTree = this.factory.newInnerNode("", null, null, 1, this.schemaManager.getCost(1));
    }

    @VisibleForTesting
    public NetworkTopologyImpl(NodeSchemaManager manager) {
        this.schemaManager = manager;
        this.maxLevel = this.schemaManager.getMaxLevel();
        this.factory = InnerNodeImpl.FACTORY;
        this.clusterTree = this.factory.newInnerNode("", null, null, 1, this.schemaManager.getCost(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Node node) {
        boolean add;
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"node cannot be null");
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allowed to add an inner node: " + node.getNetworkFullPath());
        }
        int newDepth = NetUtils.locationToDepth(node.getNetworkLocation()) + 1;
        if (this.maxLevel != newDepth) {
            throw new NetworkTopology.InvalidTopologyException("Failed to add " + node.getNetworkFullPath() + ": Its path depth is not " + this.maxLevel);
        }
        this.netlock.writeLock().lock();
        try {
            add = this.clusterTree.add(node);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
        if (add) {
            LOG.info("Added a new node: " + node.getNetworkFullPath());
            LOG.debug("NetworkTopology became:\n{}", (Object)this);
        }
    }

    @Override
    public void remove(Node node) {
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"node cannot be null");
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allowed to remove an inner node: " + node.getNetworkFullPath());
        }
        this.netlock.writeLock().lock();
        try {
            this.clusterTree.remove(node);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
        LOG.info("Removed a node: " + node.getNetworkFullPath());
        LOG.debug("NetworkTopology became:\n{}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Node node) {
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"node cannot be null");
        this.netlock.readLock().lock();
        try {
            InnerNode parent;
            for (parent = node.getParent(); parent != null && parent != this.clusterTree; parent = parent.getParent()) {
            }
            if (parent == this.clusterTree) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameAncestor(Node node1, Node node2, int ancestorGen) {
        if (node1 == null || node2 == null || ancestorGen <= 0) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = node1.getAncestor(ancestorGen) == node2.getAncestor(ancestorGen);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameParent(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            node1 = node1.getParent();
            node2 = node2.getParent();
            boolean bl = node1 == node2;
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getAncestor(Node node, int ancestorGen) {
        if (node == null) {
            return null;
        }
        this.netlock.readLock().lock();
        try {
            Node node2 = node.getAncestor(ancestorGen);
            return node2;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public Node getNode(String loc) {
        loc = NetUtils.normalize(loc);
        this.netlock.readLock().lock();
        try {
            if (!"".equals(loc)) {
                Node node = this.clusterTree.getNode(loc);
                return node;
            }
            InnerNode innerNode = this.clusterTree;
            return innerNode;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumOfLeafNode(String loc) {
        this.netlock.readLock().lock();
        try {
            Node node = this.getNode(loc);
            if (node != null) {
                int n = node.getNumOfLeaves();
                return n;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getNumOfNodes(int level) {
        Preconditions.checkArgument((level > 0 && level <= this.maxLevel ? 1 : 0) != 0, (Object)"Invalid level");
        this.netlock.readLock().lock();
        try {
            int n = this.clusterTree.getNumOfNodes(level);
            return n;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public Node chooseRandom(String scope) {
        if (scope == null) {
            scope = "";
        }
        if (scope.startsWith("~")) {
            return this.chooseRandom("", scope.substring(1), null, null, 0);
        }
        return this.chooseRandom(scope, null, null, null, 0);
    }

    @Override
    public Node chooseRandom(String scope, String excludedScope) {
        return this.chooseRandom(scope, excludedScope, null, null, 0);
    }

    @Override
    public Node chooseRandom(String scope, Collection<Node> excludedNodes) {
        if (scope == null) {
            scope = "";
        }
        if (scope.startsWith("~")) {
            return this.chooseRandom("", scope.substring(1), excludedNodes, null, 0);
        }
        return this.chooseRandom(scope, null, excludedNodes, null, 0);
    }

    @Override
    public Node chooseRandom(String scope, Collection<Node> excludedNodes, int ancestorGen) {
        if (scope == null) {
            scope = "";
        }
        if (scope.startsWith("~")) {
            return this.chooseRandom("", scope.substring(1), excludedNodes, null, ancestorGen);
        }
        return this.chooseRandom(scope, null, excludedNodes, null, ancestorGen);
    }

    @Override
    public Node chooseRandom(String scope, String excludedScope, Collection<Node> excludedNodes, int ancestorGen) {
        return this.chooseRandom(scope, excludedScope, excludedNodes, null, ancestorGen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node chooseRandom(String scope, String excludedScope, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        if (scope == null) {
            scope = "";
        }
        this.checkScope(scope);
        this.checkExcludedScope(excludedScope);
        this.checkAffinityNode(affinityNode);
        this.checkAncestorGen(ancestorGen);
        this.netlock.readLock().lock();
        try {
            Node node = this.chooseNodeInternal(scope, -1, excludedScope, excludedNodes, affinityNode, ancestorGen);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(int leafIndex, String scope, String excludedScope, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        Preconditions.checkArgument((leafIndex >= 0 ? 1 : 0) != 0);
        if (scope == null) {
            scope = "";
        }
        this.checkScope(scope);
        this.checkExcludedScope(excludedScope);
        this.checkAffinityNode(affinityNode);
        this.checkAncestorGen(ancestorGen);
        this.netlock.readLock().lock();
        try {
            Node node = this.chooseNodeInternal(scope, leafIndex, excludedScope, excludedNodes, affinityNode, ancestorGen);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    private Node chooseNodeInternal(String scope, int leafIndex, String excludedScope, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        Node ret;
        int nodeIndex;
        Preconditions.checkArgument((scope != null ? 1 : 0) != 0);
        String finalScope = scope;
        if (affinityNode != null && ancestorGen > 0) {
            Node affinityAncestor = affinityNode.getAncestor(ancestorGen);
            if (affinityAncestor == null) {
                throw new IllegalArgumentException("affinityNode " + affinityNode.getNetworkFullPath() + " doesn't have ancestor on generation  " + ancestorGen);
            }
            if (affinityAncestor.getNetworkFullPath().startsWith(scope)) {
                finalScope = affinityAncestor.getNetworkFullPath();
            } else if (!scope.startsWith(affinityAncestor.getNetworkFullPath())) {
                return null;
            }
            ancestorGen = 0;
        }
        if (excludedScope != null) {
            if (finalScope.startsWith(excludedScope)) {
                return null;
            }
            if (!excludedScope.startsWith(finalScope)) {
                excludedScope = null;
            }
        }
        Collection mutableExNodes = null;
        if (excludedNodes != null) {
            mutableExNodes = excludedNodes.stream().distinct().collect(Collectors.toList());
        }
        excludedScope = NetUtils.removeDuplicate(this, mutableExNodes, excludedScope, ancestorGen);
        Node scopeNode = this.getNode(finalScope);
        int availableNodes = this.getAvailableNodesCount(scopeNode.getNetworkFullPath(), excludedScope, mutableExNodes, ancestorGen);
        if (availableNodes <= 0) {
            LOG.warn("No available node in (scope=\"{}\" excludedScope=\"{}\" excludedNodes=\"{}\"  ancestorGen=\"{}\").", new Object[]{scopeNode.getNetworkFullPath(), excludedScope, excludedNodes, ancestorGen});
            return null;
        }
        if (!(scopeNode instanceof InnerNode)) {
            return scopeNode;
        }
        if (leafIndex >= 0) {
            nodeIndex = leafIndex % availableNodes;
            ret = ((InnerNode)scopeNode).getLeaf(nodeIndex, excludedScope, mutableExNodes, ancestorGen);
        } else {
            nodeIndex = ThreadLocalRandom.current().nextInt(availableNodes);
            ret = ((InnerNode)scopeNode).getLeaf(nodeIndex, excludedScope, mutableExNodes, ancestorGen);
        }
        LOG.debug("Choosing node[index={},random={}] from \"{}\" available nodes scope=\"{}\", excludedScope=\"{}\", excludeNodes=\"{}\".", new Object[]{nodeIndex, leafIndex == -1 ? "true" : "false", availableNodes, scopeNode.getNetworkFullPath(), excludedScope, excludedNodes});
        LOG.debug("Chosen node = {}", (Object)(ret == null ? "not found" : ret.toString()));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDistanceCost(Node node1, Node node2) {
        if (node1 != null && node2 != null && node1.equals(node2) || node1 == null && node2 == null) {
            return 0;
        }
        if (node1 == null || node2 == null) {
            LOG.warn("One of the nodes is a null pointer");
            return Integer.MAX_VALUE;
        }
        int cost = 0;
        this.netlock.readLock().lock();
        try {
            if (node1.getAncestor(this.maxLevel - 1) != this.clusterTree || node2.getAncestor(this.maxLevel - 1) != this.clusterTree) {
                LOG.debug("One of the nodes is outside of network topology");
                int n = Integer.MAX_VALUE;
                return n;
            }
            int level1 = node1.getLevel();
            int level2 = node2.getLevel();
            if (level1 > this.maxLevel || level2 > this.maxLevel) {
                int n = Integer.MAX_VALUE;
                return n;
            }
            while (level1 > level2 && node1 != null) {
                node1 = node1.getParent();
                --level1;
                cost += node1 == null ? 0 : node1.getCost();
            }
            while (level2 > level1 && node2 != null) {
                node2 = node2.getParent();
                --level2;
                cost += node2 == null ? 0 : node2.getCost();
            }
            while (node1 != null && node2 != null && node1 != node2) {
                node1 = node1.getParent();
                node2 = node2.getParent();
                cost += node1 == null ? 0 : node1.getCost();
                cost += node2 == null ? 0 : node2.getCost();
            }
            int n = cost;
            return n;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public List<? extends Node> sortByDistanceCost(Node reader, List<? extends Node> nodes, int activeLen) {
        if (reader == null) {
            return nodes;
        }
        int[] costs = new int[activeLen];
        for (int i = 0; i < activeLen; ++i) {
            costs[i] = this.getDistanceCost(reader, nodes.get(i));
        }
        TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
        for (int i = 0; i < activeLen; ++i) {
            int cost = costs[i];
            Node node = nodes.get(i);
            List list = (List)tree.get(cost);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)1);
                tree.put(cost, list);
            }
            list.add(node);
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        for (List list : tree.values()) {
            if (list == null) continue;
            Collections.shuffle(list);
            for (Node n : list) {
                ret.add(n);
            }
        }
        Preconditions.checkState((ret.size() == activeLen ? 1 : 0) != 0, (Object)"Wrong number of nodes sorted!");
        return ret;
    }

    private int getAvailableNodesCount(String scope, String excludedScope, Collection<Node> mutableExcludedNodes, int ancestorGen) {
        int availableCount;
        Iterator<Node> excludedScopeNode;
        Preconditions.checkArgument((scope != null ? 1 : 0) != 0);
        Node scopeNode = this.getNode(scope);
        if (scopeNode == null) {
            return 0;
        }
        NetUtils.removeOutscope(mutableExcludedNodes, scope);
        List<Node> excludedAncestorList = NetUtils.getAncestorList(this, mutableExcludedNodes, ancestorGen);
        for (Node ancestor : excludedAncestorList) {
            if (!scope.startsWith(ancestor.getNetworkFullPath())) continue;
            return 0;
        }
        int excludedCount = 0;
        if (excludedScope != null && (excludedScopeNode = this.getNode(excludedScope)) != null) {
            if (excludedScope.startsWith(scope)) {
                excludedCount += excludedScopeNode.getNumOfLeaves();
            } else if (scope.startsWith(excludedScope)) {
                return 0;
            }
        }
        if (mutableExcludedNodes != null && !mutableExcludedNodes.isEmpty()) {
            if (ancestorGen == 0) {
                for (Node node : mutableExcludedNodes) {
                    if (!this.contains(node)) continue;
                    ++excludedCount;
                }
            } else {
                for (Node ancestor : excludedAncestorList) {
                    if (!ancestor.getNetworkFullPath().startsWith(scope)) continue;
                    excludedCount += ancestor.getNumOfLeaves();
                }
            }
        }
        Preconditions.checkState(((availableCount = scopeNode.getNumOfLeaves() - excludedCount) >= 0 ? 1 : 0) != 0);
        return availableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder tree = new StringBuilder();
        tree.append("Level: ");
        tree.append(this.maxLevel);
        tree.append("\n");
        this.netlock.readLock().lock();
        try {
            int numOfLeaves = this.clusterTree.getNumOfLeaves();
            tree.append("Number of leaves:");
            tree.append(numOfLeaves);
            tree.append("\n");
            for (int i = 0; i < numOfLeaves; ++i) {
                tree.append(this.clusterTree.getLeaf(i).getNetworkFullPath());
                tree.append("\n");
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return tree.toString();
    }

    private void checkScope(String scope) {
        if (scope != null && scope.startsWith("~")) {
            throw new IllegalArgumentException("scope " + scope + " should not start with " + "~");
        }
    }

    private void checkExcludedScope(String excludedScope) {
        if (excludedScope != null && excludedScope.startsWith("~")) {
            throw new IllegalArgumentException("excludedScope " + excludedScope + " cannot start with " + "~");
        }
    }

    private void checkAffinityNode(Node affinityNode) {
        if (affinityNode != null && !this.contains(affinityNode)) {
            throw new IllegalArgumentException("Affinity node " + affinityNode.getNetworkFullPath() + " is not a member of topology");
        }
    }

    private void checkAncestorGen(int ancestorGen) {
        if (ancestorGen > this.maxLevel - 1 || ancestorGen < 0) {
            throw new IllegalArgumentException("ancestorGen " + ancestorGen + " exceeds this network topology acceptable level [0, " + (this.maxLevel - 1) + "]");
        }
    }
}

