/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public final class PipelineID {
    private UUID id;

    private PipelineID(UUID id) {
        this.id = id;
    }

    public static PipelineID randomId() {
        return new PipelineID(UUID.randomUUID());
    }

    public static PipelineID valueOf(UUID id) {
        return new PipelineID(id);
    }

    public UUID getId() {
        return this.id;
    }

    public HddsProtos.PipelineID getProtobuf() {
        return HddsProtos.PipelineID.newBuilder().setId(this.id.toString()).build();
    }

    public static PipelineID getFromProtobuf(HddsProtos.PipelineID protos) {
        return new PipelineID(UUID.fromString(protos.getId()));
    }

    public String toString() {
        return "PipelineID=" + this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineID that = (PipelineID)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

