/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.common.StorageInfo;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class Storage {
    private static final Logger LOG = LoggerFactory.getLogger(Storage.class);
    public static final String STORAGE_DIR_CURRENT = "current";
    protected static final String STORAGE_FILE_VERSION = "VERSION";
    public static final String CONTAINER_DIR = "containerDir";
    private final HddsProtos.NodeType nodeType;
    private final File root;
    private final File storageDir;
    private StorageState state;
    private StorageInfo storageInfo;

    public Storage(HddsProtos.NodeType type, File root, String sdName) throws IOException {
        this.nodeType = type;
        this.root = root;
        this.storageDir = new File(root, sdName);
        this.state = this.getStorageState();
        if (this.state == StorageState.INITIALIZED) {
            this.storageInfo = new StorageInfo(type, this.getVersionFile());
        } else {
            this.storageInfo = new StorageInfo(this.nodeType, StorageInfo.newClusterID(), Time.now());
            this.setNodeProperties();
        }
    }

    public String getStorageDir() {
        return this.storageDir.getAbsoluteFile().toString();
    }

    public StorageState getState() {
        return this.state;
    }

    public HddsProtos.NodeType getNodeType() {
        return this.storageInfo.getNodeType();
    }

    public String getClusterID() {
        return this.storageInfo.getClusterID();
    }

    public long getCreationTime() {
        return this.storageInfo.getCreationTime();
    }

    public void setClusterId(String clusterId) throws IOException {
        if (this.state == StorageState.INITIALIZED) {
            throw new IOException("Storage directory " + this.storageDir + " already initialized.");
        }
        this.storageInfo.setClusterId(clusterId);
    }

    protected StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    protected abstract Properties getNodeProperties();

    private void setNodeProperties() {
        Properties nodeProperties = this.getNodeProperties();
        if (nodeProperties != null) {
            for (String key : nodeProperties.stringPropertyNames()) {
                this.storageInfo.setProperty(key, nodeProperties.getProperty(key));
            }
        }
    }

    public File getCurrentDir() {
        return new File(this.storageDir, STORAGE_DIR_CURRENT);
    }

    private File getVersionFile() {
        return new File(this.getCurrentDir(), STORAGE_FILE_VERSION);
    }

    private void checkEmptyCurrent() throws IOException {
        File currentDir = this.getCurrentDir();
        if (!currentDir.exists()) {
            return;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(currentDir.toPath());){
            if (dirStream.iterator().hasNext()) {
                throw new InconsistentStorageStateException(this.getCurrentDir(), "Can't initialize the storage directory because the current it is not empty.");
            }
        }
    }

    private StorageState getStorageState() throws IOException {
        assert (this.root != null) : "root is null";
        String rootPath = this.root.getCanonicalPath();
        try {
            if (!this.root.exists()) {
                LOG.warn("Storage directory " + rootPath + " does not exist");
                return StorageState.NON_EXISTENT;
            }
            if (!this.root.isDirectory()) {
                LOG.warn(rootPath + "is not a directory");
                return StorageState.NON_EXISTENT;
            }
            if (!FileUtil.canWrite((File)this.root)) {
                LOG.warn("Cannot access storage directory " + rootPath);
                return StorageState.NON_EXISTENT;
            }
        }
        catch (SecurityException ex) {
            LOG.warn("Cannot access storage directory " + rootPath, (Throwable)ex);
            return StorageState.NON_EXISTENT;
        }
        File versionFile = this.getVersionFile();
        boolean hasCurrent = versionFile.exists();
        if (hasCurrent) {
            return StorageState.INITIALIZED;
        }
        this.checkEmptyCurrent();
        return StorageState.NOT_INITIALIZED;
    }

    public void initialize() throws IOException {
        if (this.state == StorageState.INITIALIZED) {
            throw new IOException("Storage directory already initialized.");
        }
        if (!this.getCurrentDir().mkdirs()) {
            throw new IOException("Cannot create directory " + this.getCurrentDir());
        }
        this.storageInfo.writeTo(this.getVersionFile());
    }

    public void persistCurrentState() throws IOException {
        if (!this.getCurrentDir().exists()) {
            throw new IOException("Metadata dir doesn't exist, dir: " + this.getCurrentDir());
        }
        this.storageInfo.writeTo(this.getVersionFile());
    }

    public static enum StorageState {
        NON_EXISTENT,
        NOT_INITIALIZED,
        INITIALIZED;

    }
}

