/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import io.opentracing.Scope;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;

@InterfaceAudience.Private
public final class ScmBlockLocationProtocolServerSideTranslatorPB
implements ScmBlockLocationProtocolPB {
    private final ScmBlockLocationProtocol impl;

    public ScmBlockLocationProtocolServerSideTranslatorPB(ScmBlockLocationProtocol impl) throws IOException {
        this.impl = impl;
    }

    private ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.Builder createSCMBlockResponse(ScmBlockLocationProtocolProtos.Type cmdType, String traceID) {
        return ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.newBuilder().setCmdType(cmdType).setTraceID(traceID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ScmBlockLocationProtocolProtos.SCMBlockLocationResponse send(RpcController controller, ScmBlockLocationProtocolProtos.SCMBlockLocationRequest request) throws ServiceException {
        String traceId = request.getTraceID();
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.Builder response = this.createSCMBlockResponse(request.getCmdType(), traceId);
        response.setSuccess(true);
        response.setStatus(ScmBlockLocationProtocolProtos.Status.OK);
        try (Scope scope = TracingUtil.importAndCreateScope("ScmBlockLocationProtocol." + (Object)((Object)request.getCmdType()), request.getTraceID());){
            switch (request.getCmdType()) {
                case AllocateScmBlock: {
                    response.setAllocateScmBlockResponse(this.allocateScmBlock(request.getAllocateScmBlockRequest()));
                    return response.build();
                }
                case DeleteScmKeyBlocks: {
                    response.setDeleteScmKeyBlocksResponse(this.deleteScmKeyBlocks(request.getDeleteScmKeyBlocksRequest()));
                    return response.build();
                }
                case GetScmInfo: {
                    response.setGetScmInfoResponse(this.getScmInfo(request.getGetScmInfoRequest()));
                    return response.build();
                }
                case SortDatanodes: {
                    response.setSortDatanodesResponse(this.sortDatanodes(request.getSortDatanodesRequest()));
                    return response.build();
                }
                default: {
                    throw new IOException("Unknown Operation " + (Object)((Object)request.getCmdType()) + " in ScmBlockLocationProtocol");
                }
            }
        }
        catch (IOException e) {
            response.setSuccess(false);
            response.setStatus(this.exceptionToResponseStatus(e));
            if (e.getMessage() == null) return response.build();
            response.setMessage(e.getMessage());
        }
        return response.build();
    }

    private ScmBlockLocationProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof SCMException) {
            return ScmBlockLocationProtocolProtos.Status.values()[((SCMException)ex).getResult().ordinal()];
        }
        return ScmBlockLocationProtocolProtos.Status.INTERNAL_ERROR;
    }

    public ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto allocateScmBlock(ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto request) throws IOException {
        List<AllocatedBlock> allocatedBlocks = this.impl.allocateBlock(request.getSize(), request.getNumBlocks(), request.getType(), request.getFactor(), request.getOwner(), ExcludeList.getFromProtoBuf(request.getExcludeList()));
        ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Builder builder = ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.newBuilder();
        if (allocatedBlocks.size() < request.getNumBlocks()) {
            throw new SCMException("Allocated " + allocatedBlocks.size() + " blocks. Requested " + request.getNumBlocks() + " blocks", SCMException.ResultCodes.FAILED_TO_ALLOCATE_ENOUGH_BLOCKS);
        }
        for (AllocatedBlock block : allocatedBlocks) {
            builder.addBlocks(ScmBlockLocationProtocolProtos.AllocateBlockResponse.newBuilder().setContainerBlockID(block.getBlockID().getProtobuf()).setPipeline(block.getPipeline().getProtobufMessage()));
        }
        return builder.build();
    }

    public ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto deleteScmKeyBlocks(ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto req) throws IOException {
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto.Builder resp = ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto.newBuilder();
        List<BlockGroup> infoList = req.getKeyBlocksList().stream().map(BlockGroup::getFromProto).collect(Collectors.toList());
        List<DeleteBlockGroupResult> results = this.impl.deleteKeyBlocks(infoList);
        for (DeleteBlockGroupResult result : results) {
            ScmBlockLocationProtocolProtos.DeleteKeyBlocksResultProto.Builder deleteResult = ScmBlockLocationProtocolProtos.DeleteKeyBlocksResultProto.newBuilder().setObjectKey(result.getObjectKey()).addAllBlockResults(result.getBlockResultProtoList());
            resp.addResults(deleteResult.build());
        }
        return resp.build();
    }

    public HddsProtos.GetScmInfoResponseProto getScmInfo(HddsProtos.GetScmInfoRequestProto req) throws IOException {
        ScmInfo scmInfo = this.impl.getScmInfo();
        return HddsProtos.GetScmInfoResponseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).build();
    }

    public ScmBlockLocationProtocolProtos.SortDatanodesResponseProto sortDatanodes(ScmBlockLocationProtocolProtos.SortDatanodesRequestProto request) throws ServiceException {
        ScmBlockLocationProtocolProtos.SortDatanodesResponseProto.Builder resp = ScmBlockLocationProtocolProtos.SortDatanodesResponseProto.newBuilder();
        try {
            List<String> nodeList = request.getNodeNetworkNameList();
            List<DatanodeDetails> results = this.impl.sortDatanodes(nodeList, request.getClient());
            if (results != null && results.size() > 0) {
                results.stream().forEach(dn -> resp.addNode(dn.getProtoBufMessage()));
            }
            return resp.build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }
}

